/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.SysPath;

@ThreadSafe
public final class LinuxPowerSource
extends AbstractPowerSource {
    public LinuxPowerSource(String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, PowerSource.CapacityUnits capacityUnits, int n, int n2, int n3, int n4, String string3, LocalDate localDate, String string4, String string5, double d7) {
        super(string, string2, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string3, localDate, string4, string5, d7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PowerSource> getPowerSources() {
        ArrayList<PowerSource> arrayList;
        block41: {
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            double d4 = 0.0;
            double d5 = -1.0;
            double d6 = 0.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            PowerSource.CapacityUnits capacityUnits = PowerSource.CapacityUnits.RELATIVE;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            LocalDate localDate = null;
            double d7 = 0.0;
            arrayList = new ArrayList<PowerSource>();
            if (LinuxOperatingSystem.HAS_UDEV) {
                Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
                try {
                    Udev.UdevEnumerate udevEnumerate = udevContext.enumerateNew();
                    try {
                        udevEnumerate.addMatchSubsystem("power_supply");
                        udevEnumerate.scanDevices();
                        for (Udev.UdevListEntry udevListEntry = udevEnumerate.getListEntry(); udevListEntry != null; udevListEntry = udevListEntry.getNext()) {
                            Udev.UdevDevice udevDevice;
                            String string = udevListEntry.getName();
                            String string2 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
                            if (string2.startsWith("ADP") || string2.startsWith("AC") || (udevDevice = udevContext.deviceNewFromSyspath(string)) == null) continue;
                            try {
                                if (ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_PRESENT"), 1) <= 0 || ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_ONLINE"), 1) <= 0) continue;
                                String string3 = LinuxPowerSource.getOrDefault(udevDevice, "POWER_SUPPLY_NAME", string2);
                                String string4 = udevDevice.getPropertyValue("POWER_SUPPLY_STATUS");
                                bl2 = "Charging".equals(string4);
                                bl3 = "Discharging".equals(string4);
                                d = (double)ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_CAPACITY"), -100) / 100.0;
                                n = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_ENERGY_NOW"), -1);
                                if (n < 0) {
                                    n = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_CHARGE_NOW"), -1);
                                }
                                if ((n2 = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_ENERGY_FULL"), 1)) < 0) {
                                    n2 = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_CHARGE_FULL"), 1);
                                }
                                if ((n3 = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_ENERGY_FULL_DESIGN"), 1)) < 0) {
                                    n3 = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_CHARGE_FULL_DESIGN"), 1);
                                }
                                if ((d5 = (double)ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_VOLTAGE_NOW"), -1)) > 0.0) {
                                    String string5 = udevDevice.getPropertyValue("POWER_SUPPLY_POWER_NOW");
                                    String string6 = udevDevice.getPropertyValue("POWER_SUPPLY_CURRENT_NOW");
                                    if (string5 == null) {
                                        d6 = ParseUtil.parseIntOrDefault(string6, 0);
                                        d4 = d6 * d5;
                                    } else if (string6 == null) {
                                        d4 = ParseUtil.parseIntOrDefault(string5, 0);
                                        d6 = d4 / d5;
                                    } else {
                                        d6 = ParseUtil.parseIntOrDefault(string6, 0);
                                        d4 = ParseUtil.parseIntOrDefault(string5, 0);
                                    }
                                }
                                n4 = ParseUtil.parseIntOrDefault(udevDevice.getPropertyValue("POWER_SUPPLY_CYCLE_COUNT"), -1);
                                String string7 = LinuxPowerSource.getOrDefault(udevDevice, "POWER_SUPPLY_TECHNOLOGY", "unknown");
                                String string8 = LinuxPowerSource.getOrDefault(udevDevice, "POWER_SUPPLY_MODEL_NAME", "unknown");
                                String string9 = LinuxPowerSource.getOrDefault(udevDevice, "POWER_SUPPLY_MANUFACTURER", "unknown");
                                String string10 = LinuxPowerSource.getOrDefault(udevDevice, "POWER_SUPPLY_SERIAL_NUMBER", "unknown");
                                arrayList.add(new LinuxPowerSource(string3, string8, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string7, localDate, string9, string10, d7));
                                continue;
                            }
                            finally {
                                udevDevice.unref();
                            }
                        }
                        break block41;
                    }
                    finally {
                        udevEnumerate.unref();
                    }
                }
                finally {
                    udevContext.unref();
                }
            }
            File file = new File(SysPath.POWER_SUPPLY);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return Collections.emptyList();
            }
            for (File file2 : fileArray) {
                String string = file2.getName();
                if (string.startsWith("ADP") || string.startsWith("AC")) continue;
                List<String> list = FileUtil.readFile(SysPath.POWER_SUPPLY + "/" + string + "/uevent", false);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String string11 : list) {
                    String[] stringArray = string11.split("=");
                    if (stringArray.length <= 1 || stringArray[1].isEmpty()) continue;
                    hashMap.put(stringArray[0], stringArray[1]);
                }
                String string12 = hashMap.getOrDefault("POWER_SUPPLY_NAME", string);
                String string13 = (String)hashMap.get("POWER_SUPPLY_STATUS");
                bl2 = "Charging".equals(string13);
                bl3 = "Discharging".equals(string13);
                if (hashMap.containsKey("POWER_SUPPLY_CAPACITY")) {
                    d = (double)ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_CAPACITY"), -100) / 100.0;
                }
                if (hashMap.containsKey("POWER_SUPPLY_ENERGY_NOW")) {
                    n = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_ENERGY_NOW"), -1);
                } else if (hashMap.containsKey("POWER_SUPPLY_CHARGE_NOW")) {
                    n = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_CHARGE_NOW"), -1);
                }
                if (hashMap.containsKey("POWER_SUPPLY_ENERGY_FULL")) {
                    n = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_ENERGY_FULL"), 1);
                } else if (hashMap.containsKey("POWER_SUPPLY_CHARGE_FULL")) {
                    n = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_CHARGE_FULL"), 1);
                }
                if (hashMap.containsKey("POWER_SUPPLY_ENERGY_FULL_DESIGN")) {
                    n2 = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_ENERGY_FULL_DESIGN"), 1);
                } else if (hashMap.containsKey("POWER_SUPPLY_CHARGE_FULL_DESIGN")) {
                    n2 = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_CHARGE_FULL_DESIGN"), 1);
                }
                if (hashMap.containsKey("POWER_SUPPLY_VOLTAGE_NOW")) {
                    d5 = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_VOLTAGE_NOW"), -1);
                }
                if (d5 > 0.0) {
                    if (hashMap.containsKey("POWER_SUPPLY_POWER_NOW")) {
                        d4 = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_POWER_NOW"), -1);
                    }
                    if (hashMap.containsKey("POWER_SUPPLY_CURRENT_NOW")) {
                        d6 = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_CURRENT_NOW"), -1);
                    }
                    if (d4 < 0.0 && d6 >= 0.0) {
                        d4 = d6 * d5;
                    } else if (d4 >= 0.0 && d6 < 0.0) {
                        d6 = d4 / d5;
                    } else {
                        d6 = 0.0;
                        d4 = 0.0;
                    }
                }
                if (hashMap.containsKey("POWER_SUPPLY_CYCLE_COUNT")) {
                    n4 = ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_CYCLE_COUNT"), -1);
                }
                String string14 = hashMap.getOrDefault("POWER_SUPPLY_TECHNOLOGY", "unknown");
                String string15 = hashMap.getOrDefault("POWER_SUPPLY_MODEL_NAME", "unknown");
                String string16 = hashMap.getOrDefault("POWER_SUPPLY_MANUFACTURER", "unknown");
                String string17 = hashMap.getOrDefault("POWER_SUPPLY_SERIAL_NUMBER", "unknown");
                if (ParseUtil.parseIntOrDefault((String)hashMap.get("POWER_SUPPLY_PRESENT"), 1) <= 0) continue;
                arrayList.add(new LinuxPowerSource(string12, string15, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string14, localDate, string16, string17, d7));
            }
        }
        return arrayList;
    }

    private static String getOrDefault(Udev.UdevDevice udevDevice, String string, String string2) {
        String string3 = udevDevice.getPropertyValue(string);
        return string3 == null ? string2 : string3;
    }
}

