/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import com.sun.jna.platform.unix.Resource;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.mac.ThreadInfo;
import oshi.jna.Struct;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.mac.MacOSThread;
import oshi.software.os.mac.MacOperatingSystem;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class MacOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(MacOSProcess.class);
    private static final int ARGMAX = SysctlUtil.sysctl("kern.argmax", 0);
    private static final long TICKS_PER_MS;
    private static final boolean LOG_MAC_SYSCTL_WARNING;
    private static final int MAC_RLIMIT_NOFILE = 8;
    private static final int P_LP64 = 4;
    private static final int SSLEEP = 1;
    private static final int SWAIT = 2;
    private static final int SRUN = 3;
    private static final int SIDL = 4;
    private static final int SZOMB = 5;
    private static final int SSTOP = 6;
    private int majorVersion;
    private int minorVersion;
    private final MacOperatingSystem os;
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<Pair<List<String>, Map<String, String>>> argsEnviron = Memoizer.memoize(this::queryArgsAndEnvironment);
    private String name = "";
    private String path = "";
    private String currentWorkingDirectory;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long openFiles;
    private int bitness;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;

    public MacOSProcess(int n, int n2, int n3, MacOperatingSystem macOperatingSystem) {
        super(n);
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.os = macOperatingSystem;
        this.updateAttributes();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    private String queryCommandLine() {
        return String.join((CharSequence)" ", this.getArguments());
    }

    @Override
    public List<String> getArguments() {
        return this.argsEnviron.get().getA();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.argsEnviron.get().getB();
    }

    private Pair<List<String>, Map<String, String>> queryArgsAndEnvironment() {
        int n = this.getProcessID();
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int[] nArray = new int[]{1, 49, n};
        try (Memory memory = new Memory(ARGMAX);){
            memory.clear();
            LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference((long)ARGMAX);
            if (0 == SystemB.INSTANCE.sysctl(nArray, nArray.length, (Pointer)memory, byReference, null, LibCAPI.size_t.ZERO)) {
                int n2 = memory.getInt(0L);
                if (n2 > 0 && n2 <= 1024) {
                    long l = SystemB.INT_SIZE;
                    l += (long)memory.getString(l).length();
                    while (l < byReference.longValue()) {
                        while (memory.getByte(l) == 0 && ++l < byReference.longValue()) {
                        }
                        String string = memory.getString(l);
                        if (n2-- > 0) {
                            arrayList.add(string);
                        } else {
                            int n3 = string.indexOf(61);
                            if (n3 > 0) {
                                linkedHashMap.put(string.substring(0, n3), string.substring(n3 + 1));
                            }
                        }
                        l += (long)string.length();
                    }
                }
            } else if (n > 0 && LOG_MAC_SYSCTL_WARNING) {
                LOG.warn("Failed sysctl call for process arguments (kern.procargs2), process {} may not exist. Error code: {}", (Object)n, (Object)Native.getLastError());
            }
        }
        return new Pair<List<String>, Map<String, String>>(Collections.unmodifiableList(arrayList), Collections.unmodifiableMap(linkedHashMap));
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public List<OSThread> getThreadDetails() {
        long l = System.currentTimeMillis();
        return ((Stream)ThreadInfo.queryTaskThreads(this.getProcessID()).stream().parallel()).map(threadStats -> {
            long l2 = Math.max(l - threadStats.getUpTime(), this.getStartTime());
            return new MacOSThread(this.getProcessID(), threadStats.getThreadId(), threadStats.getState(), threadStats.getSystemTime(), threadStats.getUserTime(), l2, l - l2, threadStats.getPriority());
        }).collect(Collectors.toList());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return this.openFiles;
    }

    @Override
    public long getSoftOpenFileLimit() {
        if (this.getProcessID() == this.os.getProcessId()) {
            Resource.Rlimit rlimit = new Resource.Rlimit();
            SystemB.INSTANCE.getrlimit(8, rlimit);
            return rlimit.rlim_cur;
        }
        return -1L;
    }

    @Override
    public long getHardOpenFileLimit() {
        if (this.getProcessID() == this.os.getProcessId()) {
            Resource.Rlimit rlimit = new Resource.Rlimit();
            SystemB.INSTANCE.getrlimit(8, rlimit);
            return rlimit.rlim_max;
        }
        return -1L;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    @Override
    public long getAffinityMask() {
        int n = SysctlUtil.sysctl("hw.logicalcpu", 1);
        return n < 64 ? (1L << n) - 1L : -1L;
    }

    @Override
    public long getMinorFaults() {
        return this.minorFaults;
    }

    @Override
    public long getMajorFaults() {
        return this.majorFaults;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public boolean updateAttributes() {
        long l = System.currentTimeMillis();
        try (Structure structure = new Struct.CloseableProcTaskAllInfo();){
            Object object;
            if (0 > SystemB.INSTANCE.proc_pidinfo(this.getProcessID(), 2, 0L, structure, structure.size()) || ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_threadnum < 1) {
                this.state = OSProcess.State.INVALID;
                boolean bl = false;
                return bl;
            }
            try (Object object2 = new Memory(4096L);){
                if (0 < SystemB.INSTANCE.proc_pidpath(this.getProcessID(), (Pointer)object2, 4096)) {
                    this.path = ((Pointer)object2).getString(0L).trim();
                    object = this.path.split("/");
                    if (((String[])object).length > 0) {
                        this.name = object[((String[])object).length - 1];
                    }
                }
            }
            if (this.name.isEmpty()) {
                this.name = Native.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_comm, StandardCharsets.UTF_8);
            }
            switch (((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_status) {
                case 1: {
                    this.state = OSProcess.State.SLEEPING;
                    break;
                }
                case 2: {
                    this.state = OSProcess.State.WAITING;
                    break;
                }
                case 3: {
                    this.state = OSProcess.State.RUNNING;
                    break;
                }
                case 4: {
                    this.state = OSProcess.State.NEW;
                    break;
                }
                case 5: {
                    this.state = OSProcess.State.ZOMBIE;
                    break;
                }
                case 6: {
                    this.state = OSProcess.State.STOPPED;
                    break;
                }
                default: {
                    this.state = OSProcess.State.OTHER;
                }
            }
            this.parentProcessID = ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_ppid;
            this.userID = Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_uid);
            object2 = SystemB.INSTANCE.getpwuid(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_uid);
            this.user = object2 == null ? Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_uid) : ((SystemB.Passwd)object2).pw_name;
            this.groupID = Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_gid);
            object = SystemB.INSTANCE.getgrgid(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_gid);
            this.group = object == null ? Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_gid) : object.gr_name;
            this.threadCount = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_threadnum;
            this.priority = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_priority;
            this.virtualSize = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_virtual_size;
            this.residentSetSize = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_resident_size;
            this.kernelTime = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_total_system / TICKS_PER_MS;
            this.userTime = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_total_user / TICKS_PER_MS;
            this.startTime = ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_start_tvsec * 1000L + ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_start_tvusec / 1000L;
            this.upTime = l - this.startTime;
            this.openFiles = ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_nfiles;
            this.bitness = (((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_flags & 4) == 0 ? 32 : 64;
            this.majorFaults = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_pageins;
            this.minorFaults = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_faults - ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_pageins;
            this.contextSwitches = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_csw;
        }
        if (this.majorVersion > 10 || this.minorVersion >= 9) {
            structure = new Struct.CloseableRUsageInfoV2();
            try {
                if (0 == SystemB.INSTANCE.proc_pid_rusage(this.getProcessID(), 2, (SystemB.RUsageInfoV2)structure)) {
                    this.bytesRead = ((Struct.CloseableRUsageInfoV2)structure).ri_diskio_bytesread;
                    this.bytesWritten = ((Struct.CloseableRUsageInfoV2)structure).ri_diskio_byteswritten;
                }
            }
            finally {
                ((Struct.CloseableRUsageInfoV2)structure).close();
            }
        }
        structure = new Struct.CloseableVnodePathInfo();
        try {
            if (0 < SystemB.INSTANCE.proc_pidinfo(this.getProcessID(), 9, 0L, structure, structure.size())) {
                this.currentWorkingDirectory = Native.toString(((Struct.CloseableVnodePathInfo)structure).pvi_cdir.vip_path, StandardCharsets.US_ASCII);
            }
        }
        finally {
            ((Struct.CloseableVnodePathInfo)structure).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l = 1000000000L;
        IOKit.IOIterator iOIterator = IOKitUtil.getMatchingServices("IOPlatformDevice");
        if (iOIterator != null) {
            IOKit.IORegistryEntry iORegistryEntry = iOIterator.next();
            while (iORegistryEntry != null) {
                try {
                    byte[] byArray;
                    String string = iORegistryEntry.getName().toLowerCase(Locale.ROOT);
                    if (string.startsWith("cpu") && string.length() > 3 && (byArray = iORegistryEntry.getByteArrayProperty("timebase-frequency")) != null) {
                        l = ParseUtil.byteArrayToLong(byArray, 4, false);
                        break;
                    }
                }
                finally {
                    iORegistryEntry.release();
                }
                iORegistryEntry = iOIterator.next();
            }
            iOIterator.release();
        }
        TICKS_PER_MS = l / 1000L;
        LOG_MAC_SYSCTL_WARNING = GlobalConfig.get("oshi.os.mac.sysctl.logwarning", false);
    }
}

