/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Locale;
import pro.gravit.utils.helper.JVMHelper$ARCH;
import pro.gravit.utils.helper.JVMHelper$OS;
import pro.gravit.utils.helper.LogHelper;

public final class JVMHelper {
    public static final RuntimeMXBean RUNTIME_MXBEAN = ManagementFactory.getRuntimeMXBean();
    public static final OperatingSystemMXBean OPERATING_SYSTEM_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    public static final JVMHelper$OS OS_TYPE = JVMHelper$OS.byName(OPERATING_SYSTEM_MXBEAN.getName());
    public static final int OS_BITS = JVMHelper.getCorrectOSArch();
    public static final String OS_VERSION = OPERATING_SYSTEM_MXBEAN.getVersion();
    public static final JVMHelper$ARCH ARCH_TYPE = JVMHelper.getArch(System.getProperty("os.arch"));
    public static final String NATIVE_EXTENSION = JVMHelper.getNativeExtension(OS_TYPE);
    public static final String NATIVE_PREFIX = JVMHelper.getNativePrefix(OS_TYPE);
    public static final int JVM_BITS = Integer.parseInt(System.getProperty("sun.arch.data.model"));
    public static final Runtime RUNTIME = Runtime.getRuntime();
    public static final ClassLoader LOADER = ClassLoader.getSystemClassLoader();
    public static final int JVM_VERSION = JVMHelper.getVersion();
    public static final int JVM_BUILD = JVMHelper.getBuild();

    private JVMHelper() {
    }

    public static JVMHelper$ARCH getArch(String string) {
        if (string.equals("amd64") || string.equals("x86-64") || string.equals("x86_64")) {
            return JVMHelper$ARCH.X86_64;
        }
        if (string.equals("i386") || string.equals("i586") || string.equals("i686") || string.equals("x86")) {
            return JVMHelper$ARCH.X86;
        }
        if (string.startsWith("armv8") || string.startsWith("aarch64")) {
            return JVMHelper$ARCH.ARM64;
        }
        if (string.startsWith("arm") || string.startsWith("aarch32")) {
            return JVMHelper$ARCH.ARM32;
        }
        throw new InternalError(String.format("Unsupported arch '%s'", string));
    }

    public static int getVersion() {
        return Runtime.version().feature();
    }

    public static int getBuild() {
        return Runtime.version().update();
    }

    public static String getNativeExtension(JVMHelper$OS jVMHelper$OS) {
        return switch (jVMHelper$OS.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> ".dll";
            case 1 -> ".so";
            case 2 -> ".dylib";
        };
    }

    public static String getNativePrefix(JVMHelper$OS jVMHelper$OS) {
        return switch (jVMHelper$OS.ordinal()) {
            case 1, 2 -> "lib";
            default -> "";
        };
    }

    public static void fullGC() {
        RUNTIME.gc();
        LogHelper.debug("Used heap: %d MiB", RUNTIME.totalMemory() - RUNTIME.freeMemory() >> 20);
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public static void checkStackTrace(Class<?> clazz) {
        LogHelper.debug("Testing stacktrace");
        Exception exception = new Exception("Testing stacktrace");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (!stackTraceElementArray[stackTraceElementArray.length - 1].getClassName().equals(clazz.getName())) {
            throw new SecurityException(String.format("Invalid StackTraceElement: %s", stackTraceElementArray[stackTraceElementArray.length - 1].getClassName()));
        }
    }

    private static int getCorrectOSArch() {
        if (OS_TYPE == JVMHelper$OS.MUSTDIE) {
            return System.getenv("ProgramFiles(x86)") == null ? 32 : 64;
        }
        return System.getProperty("os.arch").contains("64") ? 64 : 32;
    }

    public static boolean isJVMMatchesSystemArch() {
        return JVM_BITS == OS_BITS;
    }

    public static String jvmProperty(String string, String string2) {
        return String.format("-D%s=%s", string, string2);
    }

    public static void verifySystemProperties(Class<?> clazz, boolean bl) {
        Locale.setDefault(Locale.US);
        LogHelper.debug("Verifying class loader");
        if (bl && !clazz.getClassLoader().equals(LOADER)) {
            throw new SecurityException("ClassLoader should be system");
        }
        LogHelper.debug("Verifying JVM architecture");
    }

    static {
        try {
            MethodHandles.publicLookup();
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }
}

