/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class Selectors {
    private static Map<String, class_1814> rarities = new HashMap<String, class_1814>(){
        {
            this.put("common", class_1814.field_8906);
            this.put("uncommon", class_1814.field_8907);
            this.put("rare", class_1814.field_8903);
            this.put("epic", class_1814.field_8904);
        }
    };
    private static Map<String, BiPredicate<class_2520, String>> nbtComparators = new HashMap<String, BiPredicate<class_2520, String>>(){
        {
            this.put("=", (tag, value) -> tag.method_10714().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.method_10714().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static List<SelectorDocumentation> selectorDocumentation() {
        return Arrays.asList(new SelectorDocumentation("Match all", "Specifying just an asterisk (*) will match all items.", "*"), new SelectorDocumentation("Item ID", "Use item ID to match single items.  Must include mod name for modded items.", "minecraft:stick", "iron_ore", "spoiledeggs:spoiled_egg"), new SelectorDocumentation("Tag", "$ followed by tag name to match all items with that tag.", "$forge:stone", "$planks"), new SelectorDocumentation("Mod name", "@ followed by mod identifier to match all items from that mod.", "@spoiledeggs"), new SelectorDocumentation("Rarity", "! followed by item's rarity to match all items with that rarity.  This is ONLY vanilla rarities.", "!uncommon", "!rare", "!epic"), new SelectorDocumentation("Item name color", "# followed by color hex code, to match all items with that exact color item name.", "#23F632"), new SelectorDocumentation("Display name", "% followed by any text.  Will match any item with this text (case-sensitive) in its tooltip display name.", "%Netherite", "%Uncommon"), new SelectorDocumentation("Tooltip text", "^ followed by any text.  Will match any item with this text (case-sensitive) anywhere in the tooltip text (besides the name).", "^Legendary"), new SelectorDocumentation("NBT/Item component", "& followed by tag or component name and optional comparator (=, >, <, or !=) and value, in the format <name><comparator><value> or just <name>.", "&damage>100", "&Tier>1", "&map_id!=128", "&enchantments"), new SelectorDocumentation("Negation", "~ followed by any selector above.  This selector will be negated, matching every item that does NOT match the selector.", "~minecraft:stick", "~!uncommon", "~@minecraft"), new SelectorDocumentation("Combining selectors", "Any number of selectors can be combined by separating them with a plus sign.", "minecraft:diamond_sword+&enchantments", "minecraft:stick+~!common+&damage>100"));
    }

    public static boolean validateSelector(String value) {
        if (value.contains("+")) {
            for (String selector : value.split("\\+")) {
                if (Selectors.validateSelector(selector)) continue;
                return false;
            }
            return true;
        }
        if (value.startsWith("~")) {
            return Selectors.validateSelector(value.substring(1));
        }
        if (value.contentEquals("*")) {
            return true;
        }
        if (value.startsWith("$")) {
            return class_2960.method_12829((String)value.substring(1)) != null;
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return class_5251.method_27719((String)value).result().orElse(null) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || class_2960.method_12829((String)value) != null;
    }

    public static boolean itemMatches(class_1799 item, String selector, class_7225.class_7874 provider) {
        if (item.method_7960()) {
            return false;
        }
        if (selector.contains("+")) {
            for (String subSelector : selector.split("\\+")) {
                if (Selectors.itemMatches(item, subSelector, provider)) continue;
                return false;
            }
            return true;
        }
        if (selector.startsWith("~")) {
            return !Selectors.itemMatches(item, selector.substring(1), provider);
        }
        if (selector.contentEquals("*")) {
            return true;
        }
        String itemResourceLocation = class_7923.field_41178.method_10221((Object)item.method_7909()).toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("#")) {
            class_5251 entryColor = class_5251.method_27719((String)selector).result().orElse(null);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, class_5251.method_27717((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.method_7932() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            Optional<class_6885.class_6888> matchingTag = class_7923.field_41178.method_40272().filter(tagKey -> tagKey.method_40251().comp_327().equals((Object)class_2960.method_60654((String)selector.substring(1)))).findFirst();
            if (matchingTag.isPresent() && item.method_53187((class_6885)matchingTag.get())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.method_7954().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            class_310 mc = class_310.method_1551();
            List lines = item.method_7950(class_1792.class_9635.field_51353, (class_1657)mc.field_1724, (class_1836)class_1836.class_1837.field_41071);
            Object tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = (String)tooltipText + ((class_2561)lines.get(n)).getString() + "\n";
            }
            if (((String)tooltipText).contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            class_2520 itemTag;
            boolean result;
            CharSequence[] components;
            Object name = selector.substring(1);
            Object value = null;
            BiPredicate<class_2520, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!((String)name).contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                components = ((String)name).split(comparator);
                name = components[0];
                if (components.length <= 1) break;
                value = components[1];
                break;
            }
            if (!(result = Selectors.findMatchingSubtag(itemTag = item.method_57358(provider), (String)name, value, valueChecker))) {
                if (!((String)name).contains(":")) {
                    name = "minecraft:" + (String)name;
                }
                if (value != null) {
                    if (!((String)value).contains(":") && ((String)value).matches("^[a-z]+$")) {
                        value = "minecraft:" + (String)value;
                    } else if (((String)value).contains("\"")) {
                        components = ((String)value).split("\"");
                        for (int i = 0; i < components.length; ++i) {
                            if (i % 2 != 1 || ((String)components[i]).contains(":")) continue;
                            components[i] = "minecraft:" + (String)components[i];
                        }
                        value = String.join((CharSequence)"\"", components);
                    }
                }
                result = Selectors.findMatchingSubtag(itemTag, (String)name, (String)value, valueChecker);
            }
            return result;
        }
        return false;
    }

    private static boolean findMatchingSubtag(class_2520 tag, String key, String value, BiPredicate<class_2520, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.method_10711() == 8) {
            try {
                tag = class_2522.method_10718((String)tag.method_10714());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tag.method_10711() == 10) {
            class_2487 compoundTag = (class_2487)tag;
            if (compoundTag.method_10545(key)) {
                if (value == null && valueChecker == null) {
                    return true;
                }
                return valueChecker.test(compoundTag.method_10580(key), value);
            }
            for (String innerKey : compoundTag.method_10541()) {
                if (compoundTag.method_10540(innerKey) == 9 || compoundTag.method_10540(innerKey) == 10) {
                    if (!Selectors.findMatchingSubtag(compoundTag.method_10580(innerKey), key, value, valueChecker)) continue;
                    return true;
                }
                if (compoundTag.method_10540(innerKey) != 8) continue;
                try {
                    tag = class_2522.method_10718((String)tag.method_10714());
                    if (!Selectors.findMatchingSubtag(compoundTag.method_10580(innerKey), key, value, valueChecker)) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }
        if (tag.method_10711() == 9) {
            class_2499 listTag = (class_2499)tag;
            for (class_2520 innerTag : listTag) {
                if (innerTag.method_10711() != 9 && innerTag.method_10711() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker)) continue;
                return true;
            }
        }
        return false;
    }

    public record SelectorDocumentation(String name, String description, List<String> examples) {
        public SelectorDocumentation(String name, String description, String ... examples) {
            this(name, description, Arrays.asList(examples));
        }
    }
}

