/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.biome_particles;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeParticleSettings {
    private final ValidatedList<class_2960> biomesConfig;
    private final ValidatedInt density;
    private final int maxSpawnHeight;
    private final Supplier<? extends class_2394> particle;
    private final BiPredicate<class_1937, class_2338> spawnConditions;
    private final boolean ignoreHeight;
    private final List<class_1959> biomes = new ArrayList<class_1959>();

    public BiomeParticleSettings(ValidatedList<class_2960> biomesConfig, ValidatedInt density, int maxSpawnHeight, Supplier<? extends class_2394> particle, BiPredicate<class_1937, class_2338> spawnConditions, boolean ignoreHeight) {
        this.biomesConfig = biomesConfig;
        this.density = density;
        this.maxSpawnHeight = maxSpawnHeight;
        this.particle = particle;
        this.spawnConditions = spawnConditions;
        this.ignoreHeight = ignoreHeight;
    }

    public void update(class_1937 level) {
        this.biomes.addAll(this.biomesConfig.stream().map(location -> level.method_30349().method_30530(class_7924.field_41236).method_10223(location)).filter(Optional::isPresent).map(biomeReference -> (class_1959)((class_6880.class_6883)biomeReference.get()).comp_349()).toList());
    }

    public List<class_1959> getBiomes() {
        return this.biomes;
    }

    public void clear() {
        this.biomes.clear();
    }

    public int getDensity() {
        return (Integer)this.density.get();
    }

    public int getMaxSpawnHeight() {
        return this.maxSpawnHeight;
    }

    public Supplier<? extends class_2394> getParticle() {
        return this.particle;
    }

    public boolean checkSpawnConditions(class_1937 level, class_2338 pos) {
        return this.spawnConditions.test(level, pos);
    }

    public boolean ignoreHeight() {
        return this.ignoreHeight;
    }
}

