/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPacket;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_638;

public class ClientPacketHandlers {
    public static void handle(class_638 level, ClientBoundEntityFellPacket packet) {
        class_1297 class_12972 = level.method_8469(packet.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, packet.y(), packet.distance(), packet.fallDamage(), ClientPacketHandlers.getEntityFellConfig(packet));
        }
    }

    public static void handle(class_638 level, ClientBoundEntitySpawnSprintingDustCloudsPacket packet) {
        class_1297 class_12972 = level.method_8469(packet.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            int ySpeedModifier = 5;
            if (livingEntity instanceof class_1584) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (class_1937)level, livingEntity.method_59922(), ySpeedModifier);
        }
    }

    public static void handle(class_638 level, ClientBoundSpawnSnoreParticlePacket packet) {
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.method_8406((class_2394)ModParticles.SNORING.get(), packet.x(), packet.y(), packet.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(class_638 level, ClientBoundBlockDestroyEffectsPacket packet) {
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(packet)) {
            class_2338 pos = packet.pos();
            class_2680 state = class_2248.method_9531((int)packet.stateId());
            class_2498 soundType = state.method_26231();
            level.method_31595(pos, state);
            level.method_45446(pos, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundXPBottleEffectsPacket packet) {
        int i;
        class_2338 pos = packet.pos();
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        class_5819 random = level.method_8409();
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.VANILLA) {
            level.method_20290(2002, pos, -13083194);
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ENTITIES.xpBottleParticlesDensity.get(); ++i) {
                double d = random.method_43058() * 4.0;
                double d1 = random.method_43058() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.method_8406((class_2394)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.field_1352 + xPower * 0.1, vec3.field_1351 + 0.3, vec3.field_1350 + zPower * 0.1, xPower, 0.01 + random.method_43058() * 0.5, zPower);
            }
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8436)), vec3.field_1352, vec3.field_1351, vec3.field_1350, random.method_43059() * 0.15, random.method_43058() * 0.2, random.method_43059() * 0.15);
            }
            level.method_45446(pos, class_3417.field_14839, class_3419.field_15254, 1.0f, random.method_43057() * 0.1f + 0.9f, false);
        }
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPacket packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPacket packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundEntityFellPacket.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPacket.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPacket.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPacket.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }
}

