/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.tickers.SimpleTicker;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class TickerManager {
    private static final List<TickerProvider<?>> REGISTERED_TICKERS = new ArrayList();
    private static final Int2ObjectMap<Int2ObjectMap<Ticker<?>>> TICKERS = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<IntList> REMOVE_QUEUE = new Int2ObjectOpenHashMap();
    public static final int INNER_RANGE = 128;
    public static final int OUTER_RANGE = 144;
    private static int REGISTERED_TICKER_ID = 0;

    public static <T extends class_1297> void registerTicker(Predicate<class_1297> predicate, Function<T, Ticker<T>> function) {
        REGISTERED_TICKERS.add(new TickerProvider<T>(REGISTERED_TICKER_ID++, predicate, function));
    }

    public static <T extends class_1297> void registerSimpleTicker(class_1299<T> type, Supplier<Boolean> isEnabled, EntityProvider<T> provider) {
        TickerManager.registerSimpleTicker(entity -> entity.method_5864().equals(type) && (Boolean)isEnabled.get() != false, provider);
    }

    public static <T extends class_1297> void registerSimpleTicker(Predicate<class_1297> predicate, EntityProvider<T> provider) {
        TickerManager.registerTicker(predicate, entity -> new SimpleTicker<class_1297>((class_1297)entity, provider));
    }

    public static void tickTickers(class_1937 level) {
        TICKERS.forEach((entityId, tickers) -> {
            class_1297 entity = level.method_8469(entityId.intValue());
            if (entity != null && entity.method_5805()) {
                if (TickerManager.isEntityInRange(entity, 128)) {
                    IntArrayList removeQueue = new IntArrayList();
                    tickers.forEach((arg_0, arg_1) -> TickerManager.lambda$tickTickers$2((IntList)removeQueue, arg_0, arg_1));
                    TickerManager.remove(entityId, (IntCollection)removeQueue);
                    return;
                }
                if (!TickerManager.isEntityInRange(entity, 144)) {
                    TickerManager.remove(entityId, (IntCollection)tickers.keySet());
                }
                return;
            }
            TickerManager.remove(entityId, (IntCollection)tickers.keySet());
        });
        REMOVE_QUEUE.forEach((entityId, tickerIds) -> {
            if (TICKERS.containsKey(entityId.intValue())) {
                Int2ObjectMap tickers = (Int2ObjectMap)TICKERS.get(entityId.intValue());
                tickerIds.forEach(arg_0 -> ((Int2ObjectMap)tickers).remove(arg_0));
                if (tickers.isEmpty()) {
                    TICKERS.remove(entityId.intValue());
                }
            }
        });
        REMOVE_QUEUE.clear();
    }

    private static void remove(int entityId, IntCollection tickerIds) {
        if (tickerIds.isEmpty()) {
            return;
        }
        if (REMOVE_QUEUE.containsKey(entityId)) {
            ((IntList)REMOVE_QUEUE.get(entityId)).addAll(tickerIds);
            return;
        }
        REMOVE_QUEUE.put(entityId, (Object)new IntArrayList(tickerIds));
    }

    public static <T extends class_1297> void createTickersForEntity(T entity) {
        if (class_310.method_1551().field_1724 != null && TickerManager.isEntityInRange(entity, 128)) {
            int entityId = entity.method_5628();
            Int2ObjectOpenHashMap tickers = TICKERS.containsKey(entityId) ? (Int2ObjectMap)TICKERS.get(entityId) : new Int2ObjectOpenHashMap();
            REGISTERED_TICKERS.forEach(arg_0 -> TickerManager.lambda$createTickersForEntity$5((Int2ObjectMap)tickers, entity, arg_0));
            if (!tickers.isEmpty()) {
                TICKERS.put(entityId, (Object)tickers);
            }
        }
    }

    private static <T extends class_1297> boolean isEntityInRange(T entity, int range) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (player.method_5779(entity)) {
                return true;
            }
            class_243 position = entity.method_19538();
            return Util.isChunkLoaded(entity.method_37908(), position.method_10216(), position.method_10215()) && player.method_19538().method_24802((class_2374)position, (double)range);
        }
        return false;
    }

    public static void clear() {
        TICKERS.clear();
        REMOVE_QUEUE.clear();
    }

    private static /* synthetic */ void lambda$createTickersForEntity$5(Int2ObjectMap tickers, class_1297 entity, TickerProvider provider) {
        if (!tickers.containsKey(provider.id()) && provider.predicate().test(entity)) {
            tickers.put(provider.id(), provider.function().apply(entity));
        }
    }

    private static /* synthetic */ void lambda$tickTickers$2(IntList removeQueue, Integer tickerId, Ticker ticker) {
        if (ticker.isRemoved()) {
            removeQueue.add(tickerId.intValue());
            return;
        }
        ticker.tick();
    }

    public record TickerProvider<T extends class_1297>(int id, Predicate<class_1297> predicate, Function<T, Ticker<T>> function) {
    }
}

