/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7689;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnUtil {
    public static void spawnSparks(class_1937 level, class_5819 random, class_2338 pos, SparkType sparkType, Box box, class_243 maxSpeeds, int count, List<Integer> colors) {
        if (random.method_43056()) {
            class_243 start = box.min();
            class_243 end = box.max();
            for (int i = 0; i < count; ++i) {
                level.method_8406((class_2394)SparkParticle.create(sparkType, random, colors), (double)pos.method_10263() + class_3532.method_15366((class_5819)random, (double)start.field_1352, (double)end.field_1352), (double)pos.method_10264() + class_3532.method_15366((class_5819)random, (double)start.field_1351, (double)end.field_1351), (double)pos.method_10260() + class_3532.method_15366((class_5819)random, (double)start.field_1350, (double)end.field_1350), MathUtil.nextNonAbsDouble(random, maxSpeeds.method_10216()), MathUtil.nextNonAbsDouble(random, maxSpeeds.method_10214()), MathUtil.nextNonAbsDouble(random, maxSpeeds.method_10215()));
            }
        }
    }

    public static void spawnParticlesAroundBlock(class_2394 particle, class_1937 level, class_2338 pos, class_5819 random, int perSideChance) {
        ParticleSpawnUtil.spawnParticlesAroundBlock(particle, level, pos, random, 0.0625f, perSideChance > 0 ? direction -> random.method_43048(perSideChance) != 0 : null);
    }

    public static void spawnParticlesAroundBlock(class_2394 particle, class_1937 level, class_2338 pos, class_5819 random, float offset, @Nullable Predicate<class_2350> predicate) {
        for (class_2350 direction : class_2350.values()) {
            if (predicate != null && predicate.test(direction)) {
                return;
            }
            class_2338 relativePos = pos.method_10093(direction);
            if (level.method_8320(relativePos).method_26216()) continue;
            ParticleSpawnUtil.spawnParticlesOnSide(particle, offset, direction, level, pos, random, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesOnSide(class_2394 particle, float offset, class_2350 direction, class_1937 level, class_2338 pos, class_5819 random, double xSpeed, double ySpeed, double zSpeed) {
        double offsetFromCenter = 0.5 + (double)offset;
        class_2350.class_2351 axis = direction.method_10166();
        double xOffset = axis == class_2350.class_2351.field_11048 ? 0.5 + offsetFromCenter * (double)direction.method_10148() : (double)random.method_43057();
        double yOffset = axis == class_2350.class_2351.field_11052 ? 0.5 + offsetFromCenter * (double)direction.method_10164() : (double)random.method_43057();
        double zOffset = axis == class_2350.class_2351.field_11051 ? 0.5 + offsetFromCenter * (double)direction.method_10165() : (double)random.method_43057();
        level.method_8406(particle, (double)pos.method_10263() + xOffset, (double)pos.method_10264() + yOffset, (double)pos.method_10260() + zOffset, xSpeed, ySpeed, zSpeed);
    }

    public static void spawnFallDustClouds(class_1297 entity, float distance, int fallDamage, ClientBoundEntityFellPacket.TypeConfig config) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 && entity.equals((Object)class_310.method_1551().field_1724)) {
            ParticleSpawnUtil.spawnEntityFellParticles((class_1309)entity, entity.method_23318(), distance, fallDamage, ModConfigs.ENTITIES.dustClouds.playerFell);
        } else if (level instanceof class_3218) {
            class_3222 player;
            class_3218 serverLevel = (class_3218)level;
            Services.NETWORK.sendToClientsTracking(entity instanceof class_3222 ? (player = (class_3222)entity) : null, serverLevel, entity.method_24515(), new ClientBoundEntityFellPacket(entity.method_5628(), entity.method_23318(), distance, fallDamage, config));
        }
    }

    public static void spawnCreatureMovementDustClouds(class_1309 entity, class_1937 level, class_5819 random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.mobRunning) {
            ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig(entity, level, random, YSpeedModifier);
        }
    }

    public static void spawnCreatureMovementDustCloudsNoConfig(class_1309 entity, class_1937 level, class_5819 random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.method_8520(entity.method_24515())) {
            return;
        }
        if (entity.method_5767()) {
            return;
        }
        level.method_8406((class_2394)ModParticles.LARGE_DUST_CLOUD.get(), entity.method_19538().field_1352 + (double)entity.method_17681() * random.method_43058() - 1.0, entity.method_23318() + Math.max(Math.min((double)random.method_43057(), 0.5), 0.2), entity.method_19538().field_1350 + (double)entity.method_17681() * random.method_43058() - 1.0, 0.0, random.method_43058() * (double)YSpeedModifier, 0.0);
    }

    public static void spawnCmdBlockParticles(class_1937 level, class_243 pos, class_5819 random, BiPredicate<class_2350, class_243> directionValidator) {
        for (class_2350 direction : class_2350.values()) {
            class_243 endPos = pos.method_43206(direction, 1.0);
            class_243 relativePos = endPos.method_43206(direction, -0.5);
            if (!directionValidator.test(direction, endPos)) continue;
            class_243 speed = pos.method_1035(relativePos).method_49272(random, 1.0f);
            level.method_8406((class_2394)new DirectionParticleOptions(direction), endPos.method_10216(), endPos.method_10214(), endPos.method_10215(), speed.method_10216(), speed.method_10214(), speed.method_10215());
        }
    }

    public static void spawnHeatedWaterParticles(class_1937 level, class_2338 pos, class_5819 random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig) {
        int brightness = level.method_8314(class_1944.field_9282, pos);
        height -= 0.1;
        switch (ModConfigs.BLOCKS.steam.spawnLogic) {
            case NEAR_LAVA: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            if (!level.method_8316(pos.method_10069(x, y, z)).method_15767(class_3486.field_15518)) continue;
                            ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
                        }
                    }
                }
                break;
            }
            case BRIGHTNESS: {
                if (brightness <= (Integer)ModConfigs.BLOCKS.steam.steamingThreshold.get() && !level.method_8320(pos.method_10074()).method_27852(class_2246.field_10092)) break;
                ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
            }
        }
    }

    private static void spawnHeatedWaterParticles(class_1937 level, class_2338 pos, class_5819 random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig, int brightness) {
        if (steamConfig && !isFalling && !Util.isSolidOrNotEmpty(level, pos.method_10084())) {
            level.method_8406((class_2394)ModParticles.STEAM.get(), (double)pos.method_10263() + random.method_43058(), (double)pos.method_10264() + 0.875 + MathUtil.nextDouble(random, 0.5), (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
        }
        if (boilingConfig && brightness >= (Integer)ModConfigs.BLOCKS.steam.boilingThreshold.get()) {
            level.method_8406((class_2394)class_2398.field_11247, (double)pos.method_10263() + random.method_43058(), class_3532.method_15350((double)random.method_43058(), (double)pos.method_10264(), (double)((double)pos.method_10264() + height)), (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnEntityFellParticles(class_1309 entity, double y, float distance, int fallDamage, boolean config) {
        if (!config || entity.method_5864().method_20210(class_3483.field_42971)) {
            return;
        }
        if (entity.method_5767()) {
            return;
        }
        if (!(fallDamage > 0 || entity instanceof class_1496 && (double)distance > (entity instanceof class_7689 ? 0.5 : 1.0))) {
            return;
        }
        if (entity.method_5799() || entity.method_5771() || entity.field_27857) {
            return;
        }
        class_1937 level = entity.method_37908();
        class_5819 random = entity.method_59922();
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.method_8520(entity.method_24515())) {
            return;
        }
        if (!level.method_8316(entity.method_23312().method_33096(class_3532.method_15357((double)y))).method_15769()) {
            return;
        }
        if (fallDamage < 4) {
            for (int i = 0; i < 5; ++i) {
                level.method_8406((class_2394)ModParticles.SMALL_DUST_CLOUD.get(), entity.method_23322(1.0), y + Math.max(Math.min((double)random.method_43057(), 0.5), 0.2), entity.method_23325(1.0), 0.3 * (double)MathUtil.nextSign(random), random.method_43058(), 0.3 * (double)MathUtil.nextSign(random));
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            level.method_8406((class_2394)ModParticles.LARGE_DUST_CLOUD.get(), entity.method_23322(1.0), y + Math.max(Math.min((double)random.method_43057(), 0.5), 0.2), entity.method_23325(1.0), 0.5 * (double)MathUtil.nextSign(random), random.method_43058() * 3.0, 0.5 * (double)MathUtil.nextSign(random));
        }
    }

    public static void spawnEntityFaceParticle(class_2394 options, class_1309 entity, class_1937 level, class_5819 random, class_243 offset, float partialTick) {
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, random, new class_243(((double)random.method_43057() - 0.5) * 0.3, (double)(-random.method_43057()) * 0.6 - 0.3, 0.6).method_1019(offset), new class_243(((double)random.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1 + 0.05, 0.0), partialTick);
    }

    public static void spawnEntityFaceParticle(class_2394 options, class_1309 entity, class_1937 level, class_5819 random, class_243 offset, class_243 speed, float partialTick) {
        speed = speed.method_1037(-entity.method_5695(partialTick) * ((float)Math.PI / 180));
        speed = speed.method_1024(-entity.method_5705(partialTick) * ((float)Math.PI / 180));
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, offset, speed, partialTick);
    }

    public static void spawnEntityFaceParticle(class_2394 options, class_1309 entity, class_1937 level, class_243 offset, class_243 speed, float partialTick) {
        ParticleSpawnUtil.spawnEntityHeadParticle(options, entity, level, offset.method_1031(0.0, 0.0, 0.6), speed, partialTick);
    }

    public static void spawnEntityHeadParticle(class_2394 options, class_1309 entity, class_1937 level, class_243 pos, class_243 speed, float partialTick) {
        pos = pos.method_1037(-entity.method_5695(partialTick) * ((float)Math.PI / 180));
        pos = pos.method_1024(-entity.method_5705(partialTick) * ((float)Math.PI / 180));
        pos = pos.method_1031(entity.method_23317(), entity.method_23320(), entity.method_23321());
        level.method_8406(options, pos.method_10216(), pos.method_10214(), pos.method_10215(), speed.method_10216(), speed.method_10214(), speed.method_10215());
    }
}

