/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.event;

import com.google.common.base.Joiner;
import java.util.List;
import org.enginehub.worldeditcui.WorldEditCUI;

public final class CUIEventArgs {
    private final WorldEditCUI controller;
    private final boolean multi;
    private final String type;
    private final List<String> params;

    public CUIEventArgs(WorldEditCUI controller, boolean multi, String type, List<String> params) {
        this.controller = controller;
        this.multi = multi;
        this.type = type;
        if (params.size() == 1 && params.get(0).isEmpty()) {
            params = List.of();
        }
        this.params = params;
        this.controller.getDebugger().debug("CUI Event (" + type + ") - Params: " + Joiner.on((String)", ").join(params));
    }

    public WorldEditCUI getController() {
        return this.controller;
    }

    public List<String> getParams() {
        return this.params;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMulti() {
        return this.multi;
    }
}

