/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.event.listeners;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_5944;
import net.minecraft.class_9958;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.PipelineProvider;
import org.enginehub.worldeditcui.render.RenderSink;
import org.enginehub.worldeditcui.util.Vector3;
import org.joml.Matrix4fStack;

public class CUIListenerWorldRender {
    private final WorldEditCUI controller;
    private final class_310 minecraft;
    private final CUIRenderContext ctx = new CUIRenderContext();
    private final List<PipelineProvider> pipelines;
    private int currentPipelineIdx;
    private RenderSink sink;

    public CUIListenerWorldRender(WorldEditCUI controller, class_310 minecraft, List<PipelineProvider> pipelines) {
        this.controller = controller;
        this.minecraft = minecraft;
        this.pipelines = List.copyOf(pipelines);
    }

    private RenderSink providePipeline() {
        if (this.sink != null) {
            return this.sink;
        }
        for (int i = this.currentPipelineIdx; i < this.pipelines.size(); ++i) {
            PipelineProvider pipeline = this.pipelines.get(i);
            if (!pipeline.available()) continue;
            try {
                RenderSink sink = pipeline.provide();
                this.currentPipelineIdx = i;
                this.sink = sink;
                return this.sink;
            }
            catch (Exception ex) {
                this.controller.getDebugger().info("Failed to render with pipeline " + pipeline.id() + ", which declared itself as available... trying next");
            }
        }
        throw new IllegalStateException("No pipeline available to render with!");
    }

    private void invalidatePipeline() {
        if (this.currentPipelineIdx < this.pipelines.size() - 1) {
            ++this.currentPipelineIdx;
            this.sink = null;
        }
    }

    public void onRender(float partialTicks) {
        try {
            RenderSink sink = this.providePipeline();
            if (!this.pipelines.get(this.currentPipelineIdx).shouldRender()) {
                return;
            }
            class_3695 profiler = class_10209.method_64146();
            profiler.method_15396("worldeditcui");
            this.ctx.init(new Vector3(this.minecraft.field_1773.method_19418().method_19326()), partialTicks, sink);
            class_9958 fogStart = RenderSystem.getShaderFog();
            RenderSystem.setShaderFog((class_9958)class_9958.field_53065);
            Matrix4fStack poseStack = RenderSystem.getModelViewStack();
            poseStack.pushMatrix();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.lineWidth((float)3.0f);
            class_5944 oldShader = RenderSystem.getShader();
            try {
                this.controller.renderSelections(this.ctx);
                this.sink.flush();
            }
            catch (Exception e) {
                this.controller.getDebugger().error("Error while attempting to render WorldEdit CUI", e);
                this.invalidatePipeline();
            }
            RenderSystem.depthFunc((int)515);
            RenderSystem.setShader((class_5944)oldShader);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            poseStack.popMatrix();
            RenderSystem.setShaderFog((class_9958)fogStart);
            profiler.method_15407();
        }
        catch (Exception ex) {
            this.controller.getDebugger().error("Failed while preparing state for WorldEdit CUI", ex);
            this.invalidatePipeline();
        }
    }
}

