/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render;

import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;

public class CustomStyle
implements RenderStyle {
    private Colour colour;
    private RenderStyle.RenderType renderType = RenderStyle.RenderType.ANY;
    private final LineStyle[] lines = new LineStyle[2];

    public static CustomStyle customStyle(Colour colour) {
        CustomStyle ret = new CustomStyle(colour);
        ret.updateLines();
        return ret;
    }

    private CustomStyle(Colour colour) {
        this.colour = colour;
    }

    @Override
    public void setRenderType(RenderStyle.RenderType renderType) {
        this.renderType = renderType;
    }

    @Override
    public RenderStyle.RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public void setColour(Colour colour) {
        this.colour = colour;
        this.updateLines();
    }

    private void updateLines() {
        Colour colour = this.colour;
        this.lines[0] = new LineStyle(RenderStyle.RenderType.HIDDEN, 3.0f, Math.round((float)colour.red() * 0.75f), Math.round((float)colour.green() * 0.75f), Math.round((float)colour.blue() * 0.75f), Math.round((float)colour.alpha() * 0.25f));
        this.lines[1] = new LineStyle(RenderStyle.RenderType.VISIBLE, 3.0f, colour.red(), colour.green(), colour.blue(), colour.alpha());
    }

    @Override
    public Colour getColour() {
        return this.colour;
    }

    @Override
    public LineStyle[] getLines() {
        return this.lines;
    }
}

