/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.atlas;

import dev.notalpha.dashloader.api.CachingData;
import dev.notalpha.dashloader.api.DashModule;
import dev.notalpha.dashloader.api.cache.Cache;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.DashLoaderClient;
import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.config.Option;
import dev.notalpha.taski.builtin.StepTask;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.FutureTask;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import org.apache.commons.codec.digest.DigestUtils;

public class AtlasModule
implements DashModule<Data> {
    public static final CachingData<HashMap<String, ArrayList<FutureTask<class_1011>>>> ATLASES = new CachingData();

    @Override
    public void reset(Cache cache) {
        ATLASES.reset(cache, new HashMap());
    }

    @Override
    public Data save(RegistryWriter writer, StepTask task) {
        HashMap<String, ArrayList<FutureTask<class_1011>>> cachedAtlases = ATLASES.get(CacheStatus.SAVE);
        if (cachedAtlases == null) {
            return null;
        }
        return new Data(cachedAtlases.keySet().toArray(new String[0]));
    }

    @Override
    public void load(Data data, RegistryReader reader, StepTask t) {
        Path path = AtlasModule.getAtlasFolder();
        HashMap out = new HashMap();
        Integer maxMipLevel = (Integer)class_310.method_1551().field_1690.method_42563().method_41753();
        for (String atlasId : data.atlasIds) {
            Path imgPath;
            ArrayList<FutureTask<class_1011>> tasks = new ArrayList<FutureTask<class_1011>>();
            for (int i = 0; i <= maxMipLevel && Files.exists(imgPath = path.resolve(DigestUtils.md5Hex((String)(atlasId + i)).toUpperCase()), new LinkOption[0]); ++i) {
                tasks.add(new FutureTask<class_1011>(() -> class_1011.method_4309((InputStream)new FileInputStream(imgPath.toFile()))));
                Thread.startVirtualThread((Runnable)tasks.getLast());
            }
            out.put(atlasId, tasks);
        }
        ATLASES.set(CacheStatus.LOAD, out);
    }

    @Override
    public boolean isActive() {
        return ConfigHandler.optionActive(Option.CACHE_ATLASES);
    }

    public static Path getAtlasFolder() {
        return DashLoaderClient.CACHE.getDir().resolve("atlases");
    }

    @Override
    public Class<Data> getDataClass() {
        return Data.class;
    }

    public record Data(String[] atlasIds) {
    }
}

