/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.model;

import dev.notalpha.dashloader.api.DashObject;
import dev.notalpha.dashloader.api.collection.ObjectObjectList;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.Dazy;
import dev.notalpha.dashloader.client.model.components.BakedQuadCollection;
import dev.notalpha.dashloader.client.model.components.DashBakedQuadCollection;
import dev.notalpha.dashloader.client.model.components.DashModelTransformation;
import dev.notalpha.dashloader.client.sprite.content.DashSprite;
import dev.notalpha.dashloader.mixin.accessor.BasicBakedModelAccessor;
import dev.notalpha.hyphen.scan.annotations.DataNullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10527;
import net.minecraft.class_1058;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_5819;
import net.minecraft.class_809;

public final class DashBasicBakedModel
implements DashObject<class_1093, DazyImpl> {
    public final int quads;
    public final ObjectObjectList<class_2350, Integer> faceQuads;
    public final boolean usesAo;
    public final boolean hasDepth;
    public final boolean isSideLit;
    public final @DataNullable DashModelTransformation transformation;
    public final int spritePointer;

    public DashBasicBakedModel(int quads, ObjectObjectList<class_2350, Integer> faceQuads, boolean usesAo, boolean hasDepth, boolean isSideLit, DashModelTransformation transformation, int spritePointer) {
        this.quads = quads;
        this.faceQuads = faceQuads;
        this.usesAo = usesAo;
        this.hasDepth = hasDepth;
        this.isSideLit = isSideLit;
        this.transformation = transformation;
        this.spritePointer = spritePointer;
    }

    public DashBasicBakedModel(class_1093 basicBakedModel, RegistryWriter writer) {
        BasicBakedModelAccessor access = (BasicBakedModelAccessor)basicBakedModel;
        class_5819 random = class_5819.method_43047();
        this.quads = writer.add(new BakedQuadCollection(basicBakedModel.method_4707(null, null, random)));
        this.faceQuads = new ObjectObjectList();
        for (class_2350 value : class_2350.values()) {
            this.faceQuads.put(value, writer.add(new BakedQuadCollection(basicBakedModel.method_4707(null, value, random))));
        }
        this.usesAo = access.getUsesAo();
        this.hasDepth = access.getHasDepth();
        this.isSideLit = access.getIsSideLit();
        this.transformation = DashModelTransformation.createDashOrReturnNullIfDefault(access.getTransformation());
        this.spritePointer = writer.add(access.getSprite());
    }

    @Override
    public DazyImpl export(RegistryReader reader) {
        DashSprite.DazyImpl sprite = (DashSprite.DazyImpl)reader.get(this.spritePointer);
        DashBakedQuadCollection.DazyImpl quads = (DashBakedQuadCollection.DazyImpl)reader.get(this.quads);
        HashMap<class_2350, DashBakedQuadCollection.DazyImpl> faceQuads = new HashMap<class_2350, DashBakedQuadCollection.DazyImpl>();
        for (ObjectObjectList.ObjectObjectEntry<class_2350, Integer> entry : this.faceQuads.list()) {
            DashBakedQuadCollection.DazyImpl collection = (DashBakedQuadCollection.DazyImpl)reader.get(entry.value());
            faceQuads.put(entry.key(), collection);
        }
        return new DazyImpl(quads, faceQuads, this.usesAo, this.isSideLit, this.hasDepth, DashModelTransformation.exportOrDefault(this.transformation), sprite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashBasicBakedModel that = (DashBasicBakedModel)o;
        if (this.quads != that.quads) {
            return false;
        }
        if (this.usesAo != that.usesAo) {
            return false;
        }
        if (this.hasDepth != that.hasDepth) {
            return false;
        }
        if (this.isSideLit != that.isSideLit) {
            return false;
        }
        if (this.spritePointer != that.spritePointer) {
            return false;
        }
        if (!this.faceQuads.equals(that.faceQuads)) {
            return false;
        }
        return Objects.equals(this.transformation, that.transformation);
    }

    public int hashCode() {
        int result = this.quads;
        result = 31 * result + this.faceQuads.hashCode();
        result = 31 * result + (this.usesAo ? 1 : 0);
        result = 31 * result + (this.hasDepth ? 1 : 0);
        result = 31 * result + (this.isSideLit ? 1 : 0);
        result = 31 * result + (this.transformation != null ? this.transformation.hashCode() : 0);
        result = 31 * result + this.spritePointer;
        return result;
    }

    public static class DazyImpl
    extends Dazy<class_1093> {
        public final DashBakedQuadCollection.DazyImpl quads;
        public final Map<class_2350, DashBakedQuadCollection.DazyImpl> faceQuads;
        public final boolean usesAo;
        public final boolean isSideLit;
        public final boolean hasDepth;
        public final class_809 transformation;
        public final DashSprite.DazyImpl sprite;

        public DazyImpl(DashBakedQuadCollection.DazyImpl quads, Map<class_2350, DashBakedQuadCollection.DazyImpl> faceQuads, boolean usesAo, boolean isSideLit, boolean hasDepth, class_809 transformation, DashSprite.DazyImpl sprite) {
            this.quads = quads;
            this.faceQuads = faceQuads;
            this.usesAo = usesAo;
            this.isSideLit = isSideLit;
            this.hasDepth = hasDepth;
            this.transformation = transformation;
            this.sprite = sprite;
        }

        @Override
        protected class_1093 resolve(class_10527 spriteLoader) {
            List quads = (List)this.quads.get(spriteLoader);
            HashMap faceQuadsOut = new HashMap();
            this.faceQuads.forEach((direction, dazy) -> faceQuadsOut.put(direction, (List)dazy.get(spriteLoader)));
            class_1058 sprite = (class_1058)this.sprite.get(spriteLoader);
            return new class_1093(quads, faceQuadsOut, this.usesAo, this.isSideLit, this.hasDepth, sprite, this.transformation);
        }
    }
}

