/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.model;

import dev.notalpha.dashloader.DashLoader;
import dev.notalpha.dashloader.api.CachingData;
import dev.notalpha.dashloader.api.DashModule;
import dev.notalpha.dashloader.api.cache.Cache;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.collection.IntIntList;
import dev.notalpha.dashloader.api.collection.IntObjectList;
import dev.notalpha.dashloader.api.collection.ObjectIntList;
import dev.notalpha.dashloader.api.registry.RegistryAddException;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.Dazy;
import dev.notalpha.dashloader.client.model.components.DashModelBakeSettings;
import dev.notalpha.dashloader.client.model.fallback.MultiUnbakedBakedModel;
import dev.notalpha.dashloader.client.model.fallback.UnbakedBakedGroupableModel;
import dev.notalpha.dashloader.client.model.fallback.UnbakedBakedModel;
import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.config.Option;
import dev.notalpha.dashloader.mixin.accessor.ModelLoaderAccessor;
import dev.notalpha.taski.builtin.StepTask;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_816;
import net.minecraft.class_819;
import net.minecraft.class_9824;
import net.minecraft.class_9979;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ModelModule
implements DashModule<Data> {
    public static final CachingData<HashMap<class_1088.class_7776, class_1087>> BAKED_MODEL_PARTS = new CachingData(CacheStatus.SAVE);
    public static final CachingData<HashMap<class_1091, class_1087>> BLOCK_MODELS_SAVE = new CachingData(CacheStatus.SAVE);
    public static final CachingData<Map<class_1091, class_9824.class_9825>> RAW_BLOCK_MODELS = new CachingData(CacheStatus.SAVE);
    public static final CachingData<HashMap<class_2960, class_1100>> MODEL_PARTS = new CachingData(CacheStatus.LOAD);
    public static final CachingData<ArrayList<class_2960>> MISSING_MODEL_PARTS = new CachingData(CacheStatus.LOAD);
    public static final CachingData<Map<class_1091, class_9824.class_9825>> BLOCK_MODELS = new CachingData(CacheStatus.LOAD);
    public static final CachingData<ArrayList<class_2960>> MISSING_BLOCK_MODELS = new CachingData(CacheStatus.LOAD);
    public static final CachingData<HashMap<class_816, Pair<List<class_819>, class_2689<class_2248, class_2680>>>> MULTIPART_PREDICATES = new CachingData(CacheStatus.SAVE);
    public static final CachingData<HashMap<class_1087, class_816>> UNBAKED_TO_BAKED_MULTIPART_MODELS = new CachingData(CacheStatus.SAVE);

    public static class_2689<class_2248, class_2680> getStateManager(class_2960 identifier) {
        class_2689<class_2248, class_2680> staticDef = ModelLoaderAccessor.getStaticDefinitions().get(identifier);
        if (staticDef != null) {
            return staticDef;
        }
        return ((class_2248)class_7923.field_41175.method_63535(identifier)).method_9595();
    }

    @NotNull
    public static class_2960 getStateManagerIdentifier(class_2689<class_2248, class_2680> stateManager) {
        for (Map.Entry<class_2960, class_2689<class_2248, class_2680>> entry : ModelLoaderAccessor.getStaticDefinitions().entrySet()) {
            if (entry.getValue() != stateManager) continue;
            return entry.getKey();
        }
        return class_7923.field_41175.method_10221((Object)((class_2248)stateManager.method_11660()));
    }

    @Override
    public void reset(Cache cache) {
        BAKED_MODEL_PARTS.reset(cache, new HashMap());
        BLOCK_MODELS_SAVE.reset(cache, new HashMap());
        RAW_BLOCK_MODELS.reset(cache, new HashMap());
        MODEL_PARTS.reset(cache, new HashMap());
        MISSING_MODEL_PARTS.reset(cache, new ArrayList());
        BLOCK_MODELS.reset(cache, new HashMap());
        MISSING_BLOCK_MODELS.reset(cache, new ArrayList());
        MULTIPART_PREDICATES.reset(cache, new HashMap());
        UNBAKED_TO_BAKED_MULTIPART_MODELS.reset(cache, new HashMap());
    }

    @Override
    public Data save(RegistryWriter factory, StepTask task) {
        HashMap<class_1088.class_7776, class_1087> bakedModelCache = BAKED_MODEL_PARTS.get(CacheStatus.SAVE);
        HashMap<class_1091, class_1087> blockModels = BLOCK_MODELS_SAVE.get(CacheStatus.SAVE);
        Map<class_1091, class_9824.class_9825> rawBlockModels = RAW_BLOCK_MODELS.get(CacheStatus.SAVE);
        if (bakedModelCache == null || blockModels == null || rawBlockModels == null) {
            return null;
        }
        Int2ObjectOpenHashMap modelPartsRemap = new Int2ObjectOpenHashMap(bakedModelCache.size());
        IntObjectList<IntIntList> outModelPartsVariants = new IntObjectList<IntIntList>(new ArrayList(bakedModelCache.size()));
        IntIntList outModelParts = new IntIntList(new ArrayList<IntIntList.IntInt>(bakedModelCache.size()));
        IntArrayList missingModelParts = new IntArrayList();
        IntObjectList<IntIntList.IntInt> outBlockModels = new IntObjectList<IntIntList.IntInt>(new ArrayList(blockModels.size()));
        IntArrayList missingBlockModels = new IntArrayList();
        task.doForEach(bakedModelCache, (key, model) -> {
            if (model == null) {
                return;
            }
            try {
                int regId = factory.add(model);
                modelPartsRemap.compute(factory.add(key.comp_1053()), (id, models) -> {
                    if (models == null) {
                        models = new ObjectIntList<DashModelBakeSettings.BakeSettings>();
                    }
                    models.put(new DashModelBakeSettings.BakeSettings(key.comp_1054(), key.comp_1055()), regId);
                    return models;
                });
            }
            catch (RegistryAddException ignored) {
                missingModelParts.add(factory.add(key.comp_1053()));
            }
        });
        int[] num = new int[]{0};
        modelPartsRemap.forEach((id, models) -> {
            List list = models.list();
            num[0] = num[0] + list.size();
            if (list.size() == 1) {
                outModelParts.put((int)id, list.getFirst().value());
            } else {
                IntIntList data = new IntIntList(new ArrayList<IntIntList.IntInt>(list.size()));
                list.forEach(entry -> data.put(factory.add((DashModelBakeSettings.BakeSettings)entry.key()), entry.value()));
                outModelPartsVariants.put((int)id, data);
            }
        });
        DashLoader.LOG.info("saved {}/{} model parts", (Object)num, (Object)bakedModelCache.size());
        DashLoader.LOG.info("missing {} model parts", (Object)missingModelParts.size());
        task.doForEach(blockModels, (modelId, model) -> {
            if (model == null) {
                return;
            }
            try {
                int regId = factory.add(model);
                IntIntList.IntInt blockModel = new IntIntList.IntInt(factory.add(((class_9824.class_9825)rawBlockModels.get(modelId)).comp_3062()), regId);
                outBlockModels.put(factory.add(modelId), blockModel);
            }
            catch (RegistryAddException ignored) {
                missingBlockModels.add(factory.add(modelId.comp_2875()));
            }
        });
        DashLoader.LOG.info("saved {}/{} block models", (Object)outBlockModels.list().size(), (Object)blockModels.size());
        DashLoader.LOG.info("missing {} block models", (Object)missingBlockModels.size());
        return new Data(outModelPartsVariants, outModelParts, missingModelParts.toIntArray(), outBlockModels, missingBlockModels.toIntArray());
    }

    @Override
    public void load(Data data, RegistryReader reader, StepTask task) {
        HashMap modelParts = new HashMap(data.modelParts.list().size() + data.modelPartsVariants.list().size());
        ArrayList<class_2960> missingModelParts = new ArrayList<class_2960>(data.missingModelParts.length);
        HashMap blockModels = new HashMap(data.blockModels.list().size());
        ArrayList<class_2960> missingBlockModels = new ArrayList<class_2960>(data.missingBlockModels.length);
        data.modelPartsVariants.forEach((id, entry) -> {
            HashMap<DashModelBakeSettings.BakeSettings, Dazy<? extends class_1087>> thing = new HashMap<DashModelBakeSettings.BakeSettings, Dazy<? extends class_1087>>();
            entry.forEach((settings, model) -> thing.put((DashModelBakeSettings.BakeSettings)reader.get(settings), (Dazy)reader.get(model)));
            modelParts.put((class_2960)reader.get(id), new MultiUnbakedBakedModel(thing));
        });
        data.modelParts.forEach((id, model) -> modelParts.put((class_2960)reader.get(id), new UnbakedBakedModel((Dazy)reader.get(model))));
        for (int id2 : data.missingModelParts) {
            missingModelParts.add((class_2960)reader.get(id2));
        }
        data.blockModels.forEach((id, blockModel) -> {
            class_2680 blockState = (class_2680)reader.get(blockModel.key());
            UnbakedBakedGroupableModel dazyModel = new UnbakedBakedGroupableModel((Dazy)reader.get(blockModel.value()));
            blockModels.put((class_1091)reader.get(id), new class_9824.class_9825(blockState, (class_9979)dazyModel));
        });
        for (int id2 : data.missingBlockModels) {
            missingBlockModels.add((class_2960)reader.get(id2));
        }
        MODEL_PARTS.set(CacheStatus.LOAD, modelParts);
        MISSING_MODEL_PARTS.set(CacheStatus.LOAD, missingModelParts);
        BLOCK_MODELS.set(CacheStatus.LOAD, blockModels);
        MISSING_BLOCK_MODELS.set(CacheStatus.LOAD, missingBlockModels);
    }

    @Override
    public Class<Data> getDataClass() {
        return Data.class;
    }

    @Override
    public float taskWeight() {
        return 1000.0f;
    }

    @Override
    public boolean isActive() {
        return ConfigHandler.optionActive(Option.CACHE_MODEL_LOADER);
    }

    public static final class Data {
        public final IntObjectList<IntIntList> modelPartsVariants;
        public final IntIntList modelParts;
        public final int[] missingModelParts;
        public final IntObjectList<IntIntList.IntInt> blockModels;
        public final int[] missingBlockModels;

        public Data(IntObjectList<IntIntList> modelPartsVariants, IntIntList modelParts, int[] missingModelParts, IntObjectList<IntIntList.IntInt> blockModels, int[] missingBlockModels) {
            this.modelPartsVariants = modelPartsVariants;
            this.modelParts = modelParts;
            this.missingModelParts = missingModelParts;
            this.blockModels = blockModels;
            this.missingBlockModels = missingBlockModels;
        }
    }
}

