/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.shader;

import dev.notalpha.dashloader.api.CachingData;
import dev.notalpha.dashloader.api.DashModule;
import dev.notalpha.dashloader.api.cache.Cache;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.collection.IntIntList;
import dev.notalpha.dashloader.api.collection.IntObjectList;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.config.Option;
import dev.notalpha.taski.builtin.StepTask;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_10151;
import net.minecraft.class_10157;
import net.minecraft.class_2960;

public class ShaderModule
implements DashModule<Data> {
    public static final CachingData<HashMap<class_10151.class_10155, String>> SHADER_SOURCES = new CachingData();
    public static final CachingData<HashMap<class_2960, class_10157>> SHADER_DEFINITIONS = new CachingData();

    @Override
    public void reset(Cache cache) {
        SHADER_SOURCES.reset(cache, new HashMap());
        SHADER_DEFINITIONS.reset(cache, new HashMap());
    }

    @Override
    public Data save(RegistryWriter factory, StepTask task) {
        HashMap<class_10151.class_10155, String> data1 = SHADER_SOURCES.get(CacheStatus.SAVE);
        HashMap<class_2960, class_10157> data2 = SHADER_DEFINITIONS.get(CacheStatus.SAVE);
        if (data1 == null || data2 == null) {
            return null;
        }
        IntObjectList<String> out = new IntObjectList<String>(new ArrayList(data1.size()));
        IntIntList out2 = new IntIntList(new ArrayList<IntIntList.IntInt>(data2.size()));
        data1.forEach((identifier, entry) -> out.put(factory.add(identifier), (String)entry));
        data2.forEach((identifier, entry) -> out2.put(factory.add(identifier), factory.add(entry)));
        return new Data(out, out2);
    }

    @Override
    public void load(Data data, RegistryReader reader, StepTask task) {
        HashMap out1 = new HashMap(data.data1.list().size());
        HashMap out2 = new HashMap(data.data2.list().size());
        data.data1.forEach((key, value) -> out1.put((class_10151.class_10155)reader.get(key), value));
        data.data2.forEach((key, value) -> out2.put((class_2960)reader.get(key), (class_10157)reader.get(value)));
        SHADER_SOURCES.set(CacheStatus.LOAD, out1);
        SHADER_DEFINITIONS.set(CacheStatus.LOAD, out2);
    }

    @Override
    public Class<Data> getDataClass() {
        return Data.class;
    }

    @Override
    public boolean isActive() {
        return ConfigHandler.optionActive(Option.CACHE_SHADER);
    }

    public static final class Data {
        public final IntObjectList<String> data1;
        public final IntIntList data2;

        public Data(IntObjectList<String> data1, IntIntList data2) {
            this.data1 = data1;
            this.data2 = data2;
        }
    }
}

