/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.sprite.stitch;

import dev.notalpha.dashloader.DashLoader;
import dev.notalpha.dashloader.api.collection.IntObjectList;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.sprite.stitch.DashTextureSlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1055;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DashTextureStitcher<T extends class_1055.class_7769>
extends class_1055<T> {
    @Nullable
    private ExportedData<T> data;
    private int remainingSlots;

    public DashTextureStitcher(int maxWidth, int maxHeight, int mipLevel, @Nullable ExportedData<T> data) {
        super(maxWidth, maxHeight, mipLevel);
        this.data = data;
        this.remainingSlots = data == null ? 0 : data.slots.size();
    }

    public int method_4554() {
        if (this.data == null) {
            return super.method_4554();
        }
        return this.data.width;
    }

    public int method_4555() {
        if (this.data == null) {
            return super.method_4555();
        }
        return this.data.height;
    }

    public void method_4553(T info) {
        if (this.data == null) {
            super.method_4553(info);
            return;
        }
        class_2960 id = info.method_45816();
        DashTextureSlot slot = this.data.slots.get(id);
        if (slot == null) {
            DashLoader.LOG.warn("Sprite {} was not cached last time.", (Object)id);
            this.doFallback();
            this.method_4553(info);
            return;
        }
        if (slot.contents != null) {
            DashLoader.LOG.warn("Sprite {} was added twice??", (Object)id);
        }
        --this.remainingSlots;
        slot.contents = info;
        if (slot.width != info.method_45807() || slot.height != info.method_45815()) {
            DashLoader.LOG.warn("Sprite {} had changed dimensions since last launch, falling back.", (Object)id);
            this.doFallback();
        }
    }

    public void doFallback() {
        if (this.data != null) {
            DashLoader.LOG.error("Using fallback on texture stitcher.");
            Map slots = this.data.slots;
            this.data = null;
            slots.forEach((identifier, tDashTextureSlot) -> {
                if (tDashTextureSlot.contents != null) {
                    this.method_4553(tDashTextureSlot.contents);
                }
            });
        } else {
            DashLoader.LOG.error("Tried to fallback stitcher twice.");
        }
    }

    public void method_4557() {
        if (this.data != null && this.remainingSlots != 0) {
            DashLoader.LOG.warn("Remaining slots did not match the cached amount, Falling back.");
            this.data.slots.forEach((identifier, tDashTextureSlot) -> {
                if (tDashTextureSlot.contents == null) {
                    DashLoader.LOG.error("Sprite {} was not requested", identifier);
                }
            });
            this.doFallback();
        }
        if (this.data == null) {
            super.method_4557();
        }
    }

    public void method_4549(class_1055.class_4726<T> consumer) {
        if (this.data == null) {
            super.method_4549(consumer);
        } else {
            this.data.slots.forEach((identifier, dashTextureSlot) -> consumer.load(dashTextureSlot.contents, dashTextureSlot.x, dashTextureSlot.y));
        }
    }

    public static class ExportedData<T extends class_1055.class_7769> {
        public final Map<class_2960, DashTextureSlot<T>> slots;
        public final int width;
        public final int height;

        public ExportedData(Map<class_2960, DashTextureSlot<T>> slots, int width, int height) {
            this.slots = slots;
            this.width = width;
            this.height = height;
        }
    }

    public static class Data<T extends class_1055.class_7769> {
        public final IntObjectList<DashTextureSlot<T>> slots;
        public final int width;
        public final int height;

        public Data(IntObjectList<DashTextureSlot<T>> slots, int width, int height) {
            this.slots = slots;
            this.width = width;
            this.height = height;
        }

        public Data(RegistryWriter factory, class_1055<T> stitcher) {
            this.slots = new IntObjectList();
            stitcher.method_4549((info, x, y) -> this.slots.put(factory.add(info.method_45816()), new DashTextureSlot(x, y, info.method_45807(), info.method_45815())));
            this.width = stitcher.method_4554();
            this.height = stitcher.method_4555();
        }

        public ExportedData<T> export(RegistryReader reader) {
            HashMap output = new HashMap();
            this.slots.forEach((key, value) -> output.put((class_2960)reader.get(key), value));
            return new ExportedData(output, this.width, this.height);
        }
    }
}

