/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.sprite.stitch;

import dev.notalpha.dashloader.DashLoader;
import dev.notalpha.dashloader.api.CachingData;
import dev.notalpha.dashloader.api.DashModule;
import dev.notalpha.dashloader.api.cache.Cache;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.collection.IntObjectList;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.sprite.stitch.DashTextureStitcher;
import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.config.Option;
import dev.notalpha.taski.Task;
import dev.notalpha.taski.builtin.StepTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1055;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class SpriteStitcherModule
implements DashModule<Data> {
    public static final CachingData<List<Pair<class_2960, class_1055<?>>>> STITCHERS_SAVE = new CachingData(CacheStatus.SAVE);
    public static final CachingData<Map<class_2960, DashTextureStitcher.ExportedData<?>>> STITCHERS_LOAD = new CachingData(CacheStatus.LOAD);

    @Override
    public void reset(Cache cache) {
        STITCHERS_SAVE.reset(cache, new ArrayList());
        STITCHERS_LOAD.reset(cache, new HashMap());
    }

    @Override
    public Data save(RegistryWriter writer, StepTask task) {
        task.reset(2);
        HashMap<class_2960, DashTextureStitcher.Data> stitchers = new HashMap<class_2960, DashTextureStitcher.Data>();
        HashSet duplicate = new HashSet();
        task.run((Task)new StepTask("Caching Stitchers"), stepTask -> stepTask.doForEach(STITCHERS_SAVE.get(CacheStatus.SAVE), pair -> {
            class_1055 textureStitcher;
            class_2960 identifier = (class_2960)pair.getLeft();
            DashTextureStitcher.Data existing = stitchers.put(identifier, new DashTextureStitcher.Data(writer, textureStitcher = (class_1055)pair.getRight()));
            if (existing != null) {
                duplicate.add(identifier);
            }
        }));
        duplicate.forEach(identifier -> {
            DashLoader.LOG.warn("Duplicate stitcher {}", identifier);
            stitchers.remove(identifier);
        });
        IntObjectList output = new IntObjectList();
        stitchers.forEach((identifier, data) -> output.put(writer.add(identifier), (DashTextureStitcher.Data<?>)data));
        return new Data(output);
    }

    @Override
    public void load(Data data, RegistryReader reader, StepTask task) {
        HashMap map = new HashMap();
        data.stitchers.forEach((key, value) -> map.put((class_2960)reader.get(key), value.export(reader)));
        STITCHERS_LOAD.set(CacheStatus.LOAD, map);
    }

    @Override
    public Class<Data> getDataClass() {
        return Data.class;
    }

    @Override
    public boolean isActive() {
        return ConfigHandler.optionActive(Option.CACHE_SPRITE_STITCHING);
    }

    public static final class Data {
        public final IntObjectList<DashTextureStitcher.Data<?>> stitchers;

        public Data(IntObjectList<DashTextureStitcher.Data<?>> stitchers) {
            this.stitchers = stitchers;
        }
    }
}

