/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.ui.toast;

import dev.notalpha.dashloader.DashLoader;
import dev.notalpha.dashloader.client.ui.toast.DashToastStatus;
import dev.notalpha.dashloader.misc.TranslationHelper;
import dev.notalpha.taski.ParentTask;
import dev.notalpha.taski.Task;
import dev.notalpha.taski.builtin.AbstractTask;
import dev.notalpha.taski.builtin.StaticTask;
import net.minecraft.class_310;

public final class DashToastState {
    private final TranslationHelper translations;
    public Task task = new StaticTask("Idle", 0.0f);
    private String overwriteText;
    private DashToastStatus status;
    private double currentProgress = 0.0;
    private long lastUpdate = System.currentTimeMillis();
    private long timeDone = System.currentTimeMillis();

    public DashToastState() {
        String langCode = class_310.method_1551().method_1526().method_4669();
        DashLoader.LOG.info(langCode);
        this.translations = TranslationHelper.getInstance();
    }

    private void tickProgress() {
        double actualProgress;
        if (Double.isNaN(this.currentProgress)) {
            this.currentProgress = 0.0;
        }
        double divisionSpeed = (actualProgress = (double)this.task.getProgress()) < this.currentProgress ? 3.0 : 30.0;
        double currentProgress1 = (actualProgress - this.currentProgress) / divisionSpeed;
        this.currentProgress += currentProgress1;
    }

    public double getProgress() {
        long currentTime = System.currentTimeMillis();
        while (currentTime > this.lastUpdate) {
            this.tickProgress();
            this.lastUpdate += 10L;
        }
        return this.currentProgress;
    }

    public String getText() {
        if (this.overwriteText != null) {
            return this.overwriteText;
        }
        String text = this.concatTask(3, this.task);
        return this.translations.get(text);
    }

    public String getProgressText() {
        return this.getProgressText(3, this.task);
    }

    private String concatTask(int depth, Task task) {
        String name = null;
        if (task instanceof AbstractTask) {
            AbstractTask abstractTask = (AbstractTask)task;
            name = abstractTask.getName();
        }
        if (task instanceof ParentTask) {
            String subName;
            ParentTask stepTask = (ParentTask)task;
            Task subTask = stepTask.getChild();
            if (depth > 1 && (subName = this.concatTask(depth - 1, subTask)) != null) {
                return name + "." + subName;
            }
        }
        return name;
    }

    private String getProgressText(int depth, Task task) {
        if (task instanceof ParentTask) {
            String subName;
            ParentTask stepTask = (ParentTask)task;
            Task subTask = stepTask.getChild();
            if (depth > 1 && (subName = this.getProgressText(depth - 1, subTask)) != null) {
                return subName;
            }
        }
        if (task instanceof AbstractTask) {
            AbstractTask abstractTask = (AbstractTask)task;
            return abstractTask.getProgressText();
        }
        return null;
    }

    public void setOverwriteText(String overwriteText) {
        this.overwriteText = this.translations.get(overwriteText);
    }

    public DashToastStatus getStatus() {
        return this.status;
    }

    public void setStatus(DashToastStatus status) {
        this.status = status;
    }

    public long getTimeDone() {
        return this.timeDone;
    }

    public void setDone() {
        this.timeDone = System.currentTimeMillis();
    }
}

