/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.ui.widget;

import dev.notalpha.dashloader.misc.TranslationHelper;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.chars.CharPredicate;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7919;

public class ConfigListWidget
extends class_4265<Entry> {
    public static final int INPUT_FIELD_WIDTH = 75;
    public static final int RESET_BUTTON_WIDTH = 50;
    private final TranslationHelper translations = TranslationHelper.getInstance();

    public ConfigListWidget(class_310 minecraftClient, int i, int j, int k, int l) {
        super(minecraftClient, i, j, k, l);
    }

    public int addCategory(String label) {
        return this.method_25321((class_350.class_351)new CategoryEntry(label));
    }

    public int addBoolToggle(String label, boolean value, boolean defaultValue, BooleanConsumer saveCallback) {
        return this.method_25321((class_350.class_351)new BoolConfigEntry(label, value, defaultValue, saveCallback));
    }

    public int addIntSlider(String label, int value, int defaultValue, int min, int max, IntConsumer saveCallback) {
        return this.method_25321((class_350.class_351)new IntSliderConfigEntry(label, value, defaultValue, min, max, saveCallback));
    }

    public int addTextField(String label, String value, String defaultValue, Consumer<String> saveCallback) {
        return this.method_25321((class_350.class_351)new TextFieldEntry(label, value, defaultValue, c -> true, saveCallback));
    }

    public int addIntField(String label, int value, int defaultValue, IntConsumer saveCallback) {
        return this.method_25321((class_350.class_351)new IntFieldEntry(label, value, defaultValue, saveCallback));
    }

    public void saveValues() {
        this.method_25396().forEach(child -> {
            if (child instanceof ConfigEntry) {
                ConfigEntry entry = (ConfigEntry)((Object)child);
                entry.saveValue();
            }
        });
    }

    public int method_25322() {
        return 340;
    }

    public void update() {
        this.method_25396().forEach(Entry::update);
    }

    class CategoryEntry
    extends Entry {
        CategoryEntry(String label) {
            super(ConfigListWidget.this, label);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 textRenderer = ((ConfigListWidget)ConfigListWidget.this).field_22740.field_1772;
            int n = (ConfigListWidget.this.field_22758 - textRenderer.method_27525((class_5348)this.label)) / 2;
            Objects.requireNonNull(((ConfigListWidget)ConfigListWidget.this).field_22740.field_1772);
            context.method_51439(textRenderer, this.label, n, y + entryHeight - 9 - 1, 0xFFFFFF, false);
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }
    }

    class BoolConfigEntry
    extends ConfigEntry<Boolean> {
        BoolConfigEntry(String label, boolean value, boolean defaultValue, BooleanConsumer saveCallback) {
            super(label, value, defaultValue, saveCallback);
            this.widget = new class_4185.class_7840(class_5244.method_36134((boolean)((Boolean)this.value)), button -> {
                this.value = (Boolean)this.value == false;
                this.updateWidgetText();
                ConfigListWidget.this.update();
            }).method_46432(75).method_46431();
            this.widget.method_47400(this.tooltip);
        }

        @Override
        void updateWidgetText() {
            this.widget.method_25355(class_5244.method_36134((boolean)((Boolean)this.value)));
        }
    }

    class IntSliderConfigEntry
    extends ConfigEntry<Integer> {
        private final int min;
        private final int max;

        IntSliderConfigEntry(String label, int value, int defaultValue, int min, int max, IntConsumer saveCallback) {
            super(label, value, defaultValue, saveCallback);
            this.min = min;
            this.max = max;
            this.widget = new Slider(0, 0, 75, ConfigListWidget.this.field_22741, class_2561.method_30163((String)String.valueOf(value)), min, max, (double)((Integer)this.value - min) / (double)(max - min));
            this.widget.method_47400(this.tooltip);
        }

        @Override
        void updateWidgetText() {
            ((Slider)this.widget).setValue((double)((Integer)this.value - this.min) / (double)(this.max - this.min));
        }

        public class Slider
        extends class_357 {
            private final double min;
            private final double max;

            public Slider(int x, int y, int width, int height, class_2561 message, double min, double max, double value) {
                super(x, y, width, height, message, value);
                this.min = min;
                this.max = max;
            }

            protected void method_25346() {
                this.method_25355(class_2561.method_30163((String)String.valueOf((int)this.getValue())));
            }

            protected void method_25344() {
                IntSliderConfigEntry.this.value = (int)this.getValue();
                ConfigListWidget.this.update();
            }

            public double getValue() {
                return this.field_22753 * (this.max - this.min) + this.min;
            }

            public void setValue(double value) {
                this.field_22753 = value;
                this.method_25346();
                this.method_25344();
            }
        }
    }

    class TextFieldEntry
    extends ConfigEntry<String> {
        CharPredicate filter;

        TextFieldEntry(String label, String value, String defaultValue, CharPredicate filter, Consumer<String> saveCallback) {
            super(label, value, defaultValue, saveCallback);
            this.filter = filter;
            class_342 textWidget = new class_342(((ConfigListWidget)ConfigListWidget.this).field_22740.field_1772, 0, 0, 75, 20, (class_2561)class_2561.method_43473()){

                public boolean method_25400(char chr, int modifiers) {
                    if (TextFieldEntry.this.filter.test(chr)) {
                        return super.method_25400(chr, modifiers);
                    }
                    return false;
                }
            };
            this.widget = textWidget;
            textWidget.method_1880(Integer.MAX_VALUE);
            textWidget.method_1852(String.valueOf(this.value));
            textWidget.method_1863(text -> {
                this.value = text;
                ConfigListWidget.this.update();
            });
            textWidget.method_47400(this.tooltip);
        }

        @Override
        void updateWidgetText() {
            ((class_342)this.widget).method_1852((String)this.value);
        }
    }

    class IntFieldEntry
    extends TextFieldEntry {
        IntFieldEntry(String label, int value, int defaultValue, IntConsumer saveCallback) {
            super(label, String.valueOf(value), String.valueOf(defaultValue), chr -> chr >= '0' && chr <= '9', str -> saveCallback.accept(Integer.parseInt(str)));
            ((class_342)this.widget).method_1863(text -> {
                this.value = text.isEmpty() ? "0" : text;
                ConfigListWidget.this.update();
            });
        }

        @Override
        void updateWidgetText() {
            ((class_342)this.widget).method_1852(String.valueOf(this.value));
        }
    }

    abstract class ConfigEntry<T>
    extends Entry {
        static final class_2561 RESET_TEXT = class_2561.method_43471((String)"controls.reset");
        protected final T defaultValue;
        public class_339 widget;
        public class_4185 resetButton;
        protected T value;
        protected class_7919 tooltip;
        protected Consumer<T> saveFunc;

        ConfigEntry(String label, T value, T defaultValue, Consumer<T> saveCallback) {
            super(ConfigListWidget.this, label);
            this.value = value;
            this.defaultValue = defaultValue;
            this.saveFunc = saveCallback;
            if (ConfigListWidget.this.translations.has(label + ".tooltip")) {
                this.tooltip = class_7919.method_47407((class_2561)class_2561.method_30163((String)ConfigListWidget.this.translations.get(label + ".tooltip")));
            }
            this.resetButton = new class_4185.class_7840(RESET_TEXT, button -> {
                this.value = this.defaultValue;
                this.updateWidgetText();
                ConfigListWidget.this.update();
            }).method_46432(50).method_46431();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 class_3272 = ((ConfigListWidget)ConfigListWidget.this).field_22740.field_1772;
            Objects.requireNonNull(((ConfigListWidget)ConfigListWidget.this).field_22740.field_1772);
            context.method_51439(class_3272, this.label, x, y + (entryHeight - 9) / 2, 0xFFFFFF, false);
            this.widget.method_48229(x + entryWidth - 75 - 50 - 5, y - 2);
            this.widget.method_25394(context, mouseX, mouseY, tickDelta);
            this.resetButton.method_48229(x + entryWidth - 50, y - 2);
            this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.widget, this.resetButton);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.widget, this.resetButton);
        }

        @Override
        void update() {
            this.resetButton.field_22763 = !Objects.equals(this.value, this.defaultValue);
        }

        public T getValue() {
            return this.value;
        }

        public void saveValue() {
            this.saveFunc.accept(this.value);
        }

        abstract void updateWidgetText();
    }

    abstract class Entry
    extends class_4265.class_4266<Entry> {
        public class_2561 label;

        Entry(ConfigListWidget this$0, String label) {
            this.label = class_2561.method_30163((String)this$0.translations.get(label));
        }

        void update() {
        }
    }
}

