/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.io;

import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.io.IOHelper;
import dev.notalpha.dashloader.io.def.NativeImageData;
import dev.notalpha.dashloader.io.def.NativeImageDataDef;
import dev.notalpha.dashloader.registry.data.ChunkData;
import dev.notalpha.hyphen.HyphenSerializer;
import dev.notalpha.hyphen.SerializerFactory;
import dev.notalpha.hyphen.io.ByteBufferIO;
import dev.notalpha.hyphen.io.IOInterface;
import dev.notalpha.hyphen.scan.annotations.DataSubclasses;
import dev.notalpha.taski.builtin.StepTask;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import net.minecraft.class_391;
import org.jetbrains.annotations.NotNull;

public class Serializer<O> {
    private final HyphenSerializer<ByteBufferIO, O> serializer;

    public Serializer(Class<O> aClass) {
        SerializerFactory factory = SerializerFactory.createDebug(ByteBufferIO.class, aClass);
        factory.addAnnotationProvider(ChunkData.class, (Annotation)new DataSubclasses(this){

            public Class<? extends Annotation> annotationType() {
                return DataSubclasses.class;
            }

            public Class<?>[] value() {
                return new Class[]{ChunkData.class};
            }
        });
        factory.setClassName(Serializer.getSerializerClassName(aClass));
        factory.addAnnotationProvider(class_391.class_8544.class, (Annotation)new DataSubclasses(this){

            public Class<? extends Annotation> annotationType() {
                return DataSubclasses.class;
            }

            public Class<?>[] value() {
                return new Class[]{class_391.class_8543.class, class_391.class_8547.class, class_391.class_7736.class};
            }
        });
        factory.addDynamicDef(NativeImageData.class, NativeImageDataDef::new);
        this.serializer = factory.build();
    }

    @NotNull
    private static <O> String getSerializerClassName(Class<O> holderClass) {
        return holderClass.getSimpleName().toLowerCase() + "-serializer";
    }

    public O get(ByteBufferIO io) {
        return (O)this.serializer.get((IOInterface)io);
    }

    public void put(ByteBufferIO io, O data) {
        this.serializer.put((IOInterface)io, data);
    }

    public long measure(O data) {
        return this.serializer.measure(data);
    }

    public void save(Path path, StepTask task, O data) {
        int measure = (int)this.serializer.measure(data);
        ByteBufferIO io = ByteBufferIO.createDirect((int)measure);
        this.serializer.put((IOInterface)io, data);
        io.rewind();
        try {
            IOHelper.save(path, task, io, measure, ConfigHandler.INSTANCE.config.compression);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public O load(Path path) {
        try {
            ByteBufferIO io = IOHelper.load(path);
            return (O)this.serializer.get((IOInterface)io);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

