/*
 * Decompiled with CFR 0.152.
 */
package net.superkat.explosiveenhancement;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2664;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_4066;
import net.minecraft.class_9892;
import net.superkat.explosiveenhancement.ExplosiveEnhancement;
import net.superkat.explosiveenhancement.ExplosiveEnhancementClient;
import net.superkat.explosiveenhancement.api.ExplosionParticleType;
import net.superkat.explosiveenhancement.api.ExplosiveApi;

public class ExplosiveHandler {
    public static void spawnParticles(class_1937 world, double x, double y, double z, float power, ExplosionParticleType explosionParticleType, boolean didDestroyBlocks, boolean isImportant) {
        if (ExplosiveEnhancementClient.CONFIG.modEnabled) {
            ExplosiveHandler.logDebugInfo();
            switch (explosionParticleType) {
                case NORMAL: {
                    ExplosiveHandler.spawnExplosionParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                    break;
                }
                case WATER: {
                    ExplosiveHandler.spawnUnderwaterExplosionParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                    break;
                }
                case WIND: {
                    ExplosiveHandler.spawnWindExplosionParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                }
            }
            if (ExplosiveEnhancementClient.CONFIG.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("ExplosiveHandler finished!");
            }
        }
    }

    private static void logDebugInfo() {
        if (!ExplosiveEnhancementClient.CONFIG.debugLogs) {
            return;
        }
        ExplosiveEnhancement.LOGGER.info("ExplosiveHandler has been called!");
        ExplosiveEnhancement.LOGGER.info("Explosive Enhancement Enabled: {}", (Object)ExplosiveEnhancementClient.CONFIG.modEnabled);
        class_4066 particlesMode = (class_4066)class_310.method_1551().field_1690.method_42475().method_41753();
        ExplosiveEnhancement.LOGGER.info("Minecraft particle settings: {}", (Object)particlesMode);
        if (particlesMode == class_4066.field_18199) {
            ExplosiveEnhancement.LOGGER.warn("[Explosive Enhancement]: Minecraft's particle settings is set to Minimal! This means that no explosion particles will be shown.");
        } else if (particlesMode == class_4066.field_18198) {
            ExplosiveEnhancement.LOGGER.warn("[Explosive Enhancement]: Minecraft's particle settings is set to Decreased! This means that some explosions particles may not always be shown.");
        }
    }

    public static ExplosionParticleType determineParticleType(class_1937 world, double x, double y, double z, class_2394 particle, class_2394 emitterParticle) {
        if (ExplosiveHandler.particlesAreWindGust(particle, emitterParticle)) {
            return ExplosionParticleType.WIND;
        }
        if (ExplosiveEnhancementClient.CONFIG.underwaterExplosions && ExplosiveHandler.blockIsInWater(world, x, y, z)) {
            return ExplosionParticleType.WATER;
        }
        return ExplosionParticleType.NORMAL;
    }

    public static ExplosionParticleType determineParticleType(class_1937 world, class_243 pos, class_2394 particle) {
        if (particle == class_2398.field_49139 || particle == class_2398.field_49140) {
            return ExplosionParticleType.WIND;
        }
        if (ExplosiveEnhancementClient.CONFIG.underwaterExplosions && ExplosiveHandler.blockIsInWater(world, pos.method_10216(), pos.method_10214(), pos.method_10215())) {
            return ExplosionParticleType.WATER;
        }
        return ExplosionParticleType.NORMAL;
    }

    public static boolean blockIsInWater(class_1937 world, double x, double y, double z) {
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        return ExplosiveEnhancementClient.CONFIG.underwaterExplosions && world.method_8316(pos).method_15767(class_3486.field_15517);
    }

    public static boolean particlesAreWindGust(class_2394 particle, class_2394 emitterParticle) {
        return particle == class_2398.field_49139 && emitterParticle == class_2398.field_49140;
    }

    public static boolean particlesAreEmitter(class_2394 particle) {
        return particle == class_2398.field_11221;
    }

    private static float getPowerFromParticle(class_2394 particle) {
        float power;
        boolean emitter = ExplosiveHandler.particlesAreEmitter(particle);
        if (emitter) {
            power = 4.0f;
            if (ExplosiveEnhancementClient.CONFIG.extraPower) {
                power += ExplosiveEnhancementClient.CONFIG.bigExtraPower;
            }
        } else {
            power = 1.0f;
            if (ExplosiveEnhancementClient.CONFIG.extraPower) {
                power += ExplosiveEnhancementClient.CONFIG.smallExtraPower;
            }
        }
        return power;
    }

    public static float getPowerFromExplosionPacket(class_1937 world, class_2664 packet) {
        float power = 0.0f;
        class_2394 particle = packet.comp_2885();
        if (ExplosiveEnhancementClient.CONFIG.attemptPowerKnockbackCalc && packet.comp_2884().isPresent()) {
            power = ExplosiveApi.getPowerFromKnockback(world, packet.comp_2883(), (class_1309)class_310.method_1551().field_1724, (class_243)packet.comp_2884().get());
        }
        if (Float.isNaN(power) || power == 0.0f) {
            power = ExplosiveHandler.getPowerFromParticle(particle);
        }
        return power;
    }

    public static float attemptDeterminePowerFromKnockback(class_1937 world, class_243 explosionPos, class_1309 entity, class_243 knockback) {
        double h;
        double g;
        double e = entity.method_23317() - explosionPos.method_10216();
        double o = Math.sqrt(e * e + (g = entity.method_23320() - explosionPos.method_10214()) * g + (h = entity.method_23321() - explosionPos.method_10215()) * h);
        if (o != 0.0) {
            float dist = (float)Math.sqrt(entity.method_5707(explosionPos));
            float kbModifier = 1.0f;
            float damageRecieved = class_9892.method_61731((class_243)explosionPos, (class_1297)entity);
            float powerX = ExplosiveHandler.powerCalc((float)entity.method_23317(), (float)knockback.method_10216(), (float)explosionPos.method_10216(), dist, (float)o, kbModifier, damageRecieved);
            float powerY = ExplosiveHandler.powerCalc((float)entity.method_23320(), (float)knockback.method_10214(), (float)explosionPos.method_10214(), dist, (float)o, kbModifier, damageRecieved);
            float powerZ = ExplosiveHandler.powerCalc((float)entity.method_23321(), (float)knockback.method_10215(), (float)explosionPos.method_10215(), dist, (float)o, kbModifier, damageRecieved);
            float avgPower = (powerX + powerY + powerZ) / 3.0f;
            return avgPower;
        }
        return 0.0f;
    }

    public static float powerCalc(float entityPos, float knockbackAmount, float explosionPos, float dist, float distO, float knockbackModifier, float receivedDamage) {
        return dist / (-(knockbackAmount * distO / ((entityPos - explosionPos) * knockbackModifier * receivedDamage)) + 1.0f) / 2.0f;
    }

    public static void spawnExplosionParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        power = ExplosiveEnhancementClient.CONFIG.dynamicSize ? power : 4.0f;
        y = ExplosiveEnhancementClient.CONFIG.attemptBetterSmallExplosions && power == 1.0f ? y + ExplosiveEnhancementClient.CONFIG.smallExplosionYOffset : y;
        isImportant |= ExplosiveEnhancementClient.CONFIG.alwaysShow;
        float blastwavePower = power * 1.75f;
        float fireballPower = power * 1.25f;
        float smokePower = power * 0.4f;
        if (ExplosiveEnhancementClient.CONFIG.showBlastWave) {
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.BLASTWAVE, isImportant, x, y, z, blastwavePower, 0.0, 0.0);
        }
        if (ExplosiveEnhancementClient.CONFIG.showFireball) {
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.FIREBALL, isImportant, x, y + 0.5, z, fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        } else if (ExplosiveEnhancementClient.CONFIG.showSparks) {
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.BLANK_FIREBALL, isImportant, x, y + 0.5, z, fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        }
        if (ExplosiveEnhancementClient.CONFIG.showMushroomCloud) {
            ExplosiveHandler.spawnMushroomCloud(world, x, y, z, power, smokePower, isImportant);
        }
    }

    public static void spawnUnderwaterExplosionParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        power = ExplosiveEnhancementClient.CONFIG.dynamicUnderwater ? power : 4.0f;
        y = ExplosiveEnhancementClient.CONFIG.attemptBetterSmallExplosions && power == 1.0f ? y + ExplosiveEnhancementClient.CONFIG.smallExplosionYOffset : y;
        isImportant = isImportant || ExplosiveEnhancementClient.CONFIG.alwaysShow;
        float blastwavePower = power * 1.75f;
        float fireballPower = power * 1.25f;
        if (ExplosiveEnhancementClient.CONFIG.showUnderwaterBlastWave) {
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.UNDERWATERBLASTWAVE, isImportant, x, y + 0.5, z, blastwavePower, 0.0, 0.0);
        }
        if (ExplosiveEnhancementClient.CONFIG.showShockwave) {
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SHOCKWAVE, isImportant, x, y + 0.5, z, fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        } else if (ExplosiveEnhancementClient.CONFIG.showUnderwaterSparks) {
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.BLANK_SHOCKWAVE, isImportant, x, y + 0.5, z, fireballPower, isImportant ? 1.0 : 0.0, 0.0);
        }
        ExplosiveHandler.spawnBubble(world, x, y, z, isImportant);
    }

    private static void spawnMushroomCloud(class_1937 world, double x, double y, double z, float power, double smokePower, boolean isImportant) {
        ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, power, (double)power * 0.25, 0.0);
        ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, power, smokePower, 0.0);
        ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, 0.15, smokePower, power);
        ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, -0.15, smokePower, power);
        ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, power, smokePower, 0.15);
        ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, power, smokePower, -0.15);
    }

    private static void spawnBubble(class_1937 world, double x, double y, double z, boolean isImportant) {
        for (int i = 0; i < ExplosiveEnhancementClient.CONFIG.bubbleAmount; ++i) {
            double velX = (double)world.field_9229.method_39332(1, 7) * 0.3 * (double)world.field_9229.method_39332(-1, 1);
            double velY = (double)world.field_9229.method_39332(1, 10) * 0.1;
            double velZ = (double)world.field_9229.method_39332(1, 7) * 0.3 * (double)world.field_9229.method_39332(-1, 1);
            ExplosiveHandler.addParticle(world, (class_2394)ExplosiveEnhancement.BUBBLE, isImportant, x, y, z, velX, velY, velZ);
        }
    }

    public static void spawnWindExplosionParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        ExplosiveHandler.spawnVanillaParticles(world, x, y, z, power, didDestroyBlocks, isImportant, true);
    }

    private static void spawnVanillaParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant, boolean wind) {
        class_2400 particle = wind ? class_2398.field_49139 : class_2398.field_11236;
        class_2400 emitter = wind ? class_2398.field_49140 : class_2398.field_11221;
        ExplosiveHandler.addParticle(world, (class_2394)(power >= 2.0f && didDestroyBlocks ? emitter : particle), isImportant, x, y, z, 1.0, 0.0, 0.0);
    }

    private static void addParticle(class_1937 world, class_2394 particle, boolean isImportant, double x, double y, double z, double velX, double velY, double velZ) {
        world.method_8466(particle, isImportant, isImportant, x, y, z, velX, velY, velZ);
    }
}

