/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackAnimationRenderer
implements IAnimationRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String resourceNamespace;
    protected List<String> frameNames;
    protected int fps;
    protected boolean loop;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    public List<class_2960> resources = new ArrayList<class_2960>();
    protected boolean stretch = false;
    protected boolean hide = false;
    protected volatile boolean done = false;
    private int frame = 0;
    public long prevTime = 0L;
    protected float opacity = 1.0f;
    protected boolean ready = false;
    protected boolean sizeSet = false;

    public ResourcePackAnimationRenderer(@Nullable String resourceNamespace, List<String> frameNames, int fps, boolean loop, int posX, int posY, int width, int height) {
        this.fps = fps;
        this.loop = loop;
        this.x = posX;
        this.y = posY;
        this.width = width;
        this.height = height;
        this.resourceNamespace = resourceNamespace;
        this.frameNames = frameNames;
        this.loadAnimationFrames();
    }

    private void loadAnimationFrames() {
        try {
            for (String s : this.frameNames) {
                class_2960 r = this.resourceNamespace == null ? class_2960.method_60654((String)s) : class_2960.method_60655((String)this.resourceNamespace, (String)s);
                this.resources.add(r);
            }
            this.ready = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(class_332 graphics) {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        if (this.fps < 0) {
            this.fps = -1;
        }
        if (this.frame > this.resources.size() - 1) {
            if (this.loop) {
                this.resetAnimation();
            } else {
                this.done = true;
                if (!this.hide) {
                    this.frame = this.resources.size() - 1;
                } else {
                    return;
                }
            }
        }
        this.renderFrame(graphics);
        long time = System.currentTimeMillis();
        if (this.fps == -1) {
            this.updateFrame(time);
        } else if (this.prevTime + (long)(1000 / this.fps) <= time) {
            this.updateFrame(time);
        }
    }

    protected void renderFrame(class_332 graphics) {
        int h = this.height;
        int w = this.width;
        int x2 = this.x;
        int y2 = this.y;
        if (this.stretch && class_310.method_1551().field_1755 != null) {
            h = class_310.method_1551().field_1755.field_22790;
            w = class_310.method_1551().field_1755.field_22789;
            x2 = 0;
            y2 = 0;
        }
        graphics.method_25291(class_1921::method_62277, this.resources.get(this.frame), x2, y2, 0.0f, 0.0f, w, h, w, h, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
        RenderSystem.disableBlend();
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void updateFrame(long time) {
        ++this.frame;
        this.prevTime = time;
    }

    public void resetAnimation() {
        this.frame = 0;
        this.prevTime = 0L;
        this.done = false;
    }

    public void setStretchImageToScreensize(boolean b) {
        this.stretch = b;
    }

    public void setHideAfterLastFrame(boolean b) {
        this.hide = b;
    }

    public boolean isFinished() {
        return this.done;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int currentFrame() {
        return this.frame;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setPosX(int x) {
        this.x = x;
    }

    public void setPosY(int y) {
        this.y = y;
    }

    public int animationFrames() {
        return this.resources.size();
    }

    public List<class_2960> getAnimationFrames() {
        return this.resources;
    }

    public String getPath() {
        return this.resourceNamespace;
    }

    public void setFPS(int fps) {
        this.fps = fps;
    }

    public int getFPS() {
        return this.fps;
    }

    public void setLooped(boolean b) {
        this.loop = b;
    }

    public void prepareAnimation() {
    }

    public boolean isGettingLooped() {
        return this.loop;
    }

    public boolean isStretchedToStreensize() {
        return this.stretch;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public boolean setupAnimationSize() {
        if (this.sizeSet) {
            return true;
        }
        try {
            class_2960 r;
            List<class_2960> l = this.getAnimationFrames();
            if (!l.isEmpty() && (r = l.get(0)) != null) {
                class_1011 i = class_1011.method_4309((InputStream)class_310.method_1551().method_1478().open(r));
                this.width = i.method_4307();
                this.height = i.method_4323();
                this.sizeSet = true;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.error("[FANCYMENU] Failed to update width and height for resource pack animation: " + this.resourceNamespace);
        return false;
    }
}

