/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.cycle.ILocalizedValueCycle;
import de.keksuccino.fancymenu.util.properties.RuntimePropertyContainer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextMenu
implements class_4068,
class_364,
class_6379,
NavigatableWidget,
FancyMenuUiComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 SUB_CONTEXT_MENU_ARROW_ICON = class_2960.method_60655((String)"fancymenu", (String)"textures/contextmenu/context_menu_sub_arrow.png");
    private static final class_2960 CONTEXT_MENU_TOOLTIP_ICON = class_2960.method_60655((String)"fancymenu", (String)"textures/contextmenu/context_menu_tooltip.png");
    private static final DrawableColor SHADOW_COLOR = DrawableColor.of(new Color(43, 43, 43, 100));
    protected final List<ContextMenuEntry<?>> entries = new ArrayList();
    protected float scale = UIBase.getUIScale();
    protected boolean forceUIScale = true;
    protected boolean open = false;
    protected float rawX;
    protected float rawY;
    protected float rawWidth;
    protected float rawHeight;
    protected SubMenuContextMenuEntry parentEntry = null;
    protected SubMenuOpeningSide subMenuOpeningSide = SubMenuOpeningSide.RIGHT;
    protected boolean shadow = true;
    protected boolean keepDistanceToEdges = true;
    protected boolean forceDefaultTooltipStyle = true;
    protected boolean forceRawXY = false;
    protected boolean forceSide = false;
    protected boolean forceSideSubMenus = true;

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.isOpen()) {
            return;
        }
        if (this.forceUIScale) {
            this.scale = UIBase.getUIScale();
        }
        float scale = UIBase.calculateFixedScale(this.getScale());
        RenderSystem.enableBlend();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(scale, scale, scale);
        graphics.method_51448().method_46416(0.0f, 0.0f, 500.0f / scale);
        ArrayList<ContextMenuEntry> renderEntries = new ArrayList<ContextMenuEntry>();
        renderEntries.add(new SpacerContextMenuEntry("unregistered_spacer_top", this));
        boolean addIconSpace = false;
        for (ContextMenuEntry<?> e : this.entries) {
            if (!(e instanceof ClickableContextMenuEntry)) continue;
            ClickableContextMenuEntry clickableContextMenuEntry = (ClickableContextMenuEntry)e;
            if (clickableContextMenuEntry.icon == null) continue;
            addIconSpace = true;
            break;
        }
        this.rawWidth = 20.0f;
        this.rawHeight = 0.0f;
        ContextMenuEntry prev = null;
        for (ContextMenuEntry contextMenuEntry : this.entries) {
            float w;
            contextMenuEntry.addSpaceForIcon = addIconSpace;
            if (contextMenuEntry instanceof SeparatorContextMenuEntry && (prev instanceof SeparatorContextMenuEntry || contextMenuEntry == this.entries.get(0) || contextMenuEntry == this.entries.get(this.entries.size() - 1))) {
                prev = contextMenuEntry;
                continue;
            }
            if (!contextMenuEntry.isVisible()) {
                prev = contextMenuEntry;
                continue;
            }
            if (contextMenuEntry.tickAction != null) {
                contextMenuEntry.tickAction.run(this, contextMenuEntry, false);
            }
            if ((w = contextMenuEntry.getMinWidth()) > this.rawWidth) {
                this.rawWidth = w;
            }
            this.rawHeight += contextMenuEntry.getHeight();
            renderEntries.add(contextMenuEntry);
            prev = contextMenuEntry;
        }
        this.rawHeight += 8.0f;
        renderEntries.add(new SpacerContextMenuEntry("unregistered_spacer_bottom", this));
        float x = this.getActualX();
        float f = this.getActualY();
        float scaledX = x / scale + this.getBorderThickness();
        float scaledY = f / scale + this.getBorderThickness();
        float scaledMouseX = (float)mouseX / scale;
        float scaledMouseY = (float)mouseY / scale;
        boolean navigatingInSub = this.isUserNavigatingInSubMenu();
        if (this.hasShadow()) {
            RenderingUtils.fillF(graphics, scaledX + 4.0f, scaledY + 4.0f, scaledX + this.getWidth() + 4.0f, scaledY + this.getHeight() + 4.0f, SHADOW_COLOR.getColorInt());
        }
        RenderingUtils.fillF(graphics, scaledX, scaledY, scaledX + this.getWidth(), scaledY + this.getHeight(), UIBase.getUIColorTheme().element_background_color_normal.getColorInt());
        float entryY = scaledY;
        for (ContextMenuEntry e : renderEntries) {
            e.x = scaledX;
            e.y = entryY;
            e.width = this.getWidth();
            boolean hover = e.isHovered();
            e.setHovered(!navigatingInSub && UIBase.isXYInArea(scaledMouseX, scaledMouseY, e.x, e.y, e.width, e.getHeight()));
            if (!hover && e.isHovered() && e.hoverAction != null) {
                e.hoverAction.run(this, e, false);
            }
            RenderSystem.enableBlend();
            e.method_25394(graphics, (int)scaledMouseX, (int)scaledMouseY, partial);
            entryY += e.getHeight();
        }
        UIBase.renderBorder(graphics, scaledX - this.getBorderThickness(), scaledY - this.getBorderThickness(), scaledX + this.getWidth() + this.getBorderThickness(), scaledY + this.getHeight() + this.getBorderThickness(), this.getBorderThickness(), UIBase.getUIColorTheme().element_border_color_normal.getColorInt(), true, true, true, true);
        for (ContextMenuEntry e : renderEntries) {
            if (e.tickAction == null) continue;
            e.tickAction.run(this, e, true);
        }
        graphics.method_51448().method_22909();
        for (ContextMenuEntry e : renderEntries) {
            if (!(e instanceof SubMenuContextMenuEntry)) continue;
            SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
            if (this.forceSideSubMenus) {
                s.subContextMenu.forceSide = this.forceSide;
            }
            s.subContextMenu.forceRawXY = this.forceRawXY;
            s.subContextMenu.shadow = this.shadow;
            s.subContextMenu.scale = this.scale;
            s.subContextMenu.forceUIScale = this.forceUIScale;
            s.subContextMenu.method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    @NotNull
    public SubMenuContextMenuEntry addSubMenuEntryAt(int index, @NotNull String identifier, @NotNull class_2561 label, @NotNull ContextMenu subContextMenu) {
        SubMenuContextMenuEntry e = new SubMenuContextMenuEntry(identifier, this, label, subContextMenu);
        return this.addEntryAt(index, e);
    }

    @NotNull
    public SubMenuContextMenuEntry addSubMenuEntryBefore(@NotNull String addBeforeIdentifier, @NotNull String identifier, @NotNull class_2561 label, @NotNull ContextMenu subContextMenu) {
        SubMenuContextMenuEntry e = new SubMenuContextMenuEntry(identifier, this, label, subContextMenu);
        return this.addEntryBefore(addBeforeIdentifier, e);
    }

    @NotNull
    public SubMenuContextMenuEntry addSubMenuEntryAfter(@NotNull String addAfterIdentifier, @NotNull String identifier, @NotNull class_2561 label, @NotNull ContextMenu subContextMenu) {
        SubMenuContextMenuEntry e = new SubMenuContextMenuEntry(identifier, this, label, subContextMenu);
        return this.addEntryAfter(addAfterIdentifier, e);
    }

    @NotNull
    public SubMenuContextMenuEntry addSubMenuEntry(@NotNull String identifier, @NotNull class_2561 label, @NotNull ContextMenu subContextMenu) {
        SubMenuContextMenuEntry e = new SubMenuContextMenuEntry(identifier, this, label, subContextMenu);
        return this.addEntry(e);
    }

    @NotNull
    public SeparatorContextMenuEntry addSeparatorEntryAt(int index, @NotNull String identifier) {
        SeparatorContextMenuEntry e = new SeparatorContextMenuEntry(identifier, this);
        return this.addEntryAt(index, e);
    }

    @NotNull
    public SeparatorContextMenuEntry addSeparatorEntryBefore(@NotNull String addBeforeIdentifier, @NotNull String identifier) {
        SeparatorContextMenuEntry e = new SeparatorContextMenuEntry(identifier, this);
        return this.addEntryBefore(addBeforeIdentifier, e);
    }

    @NotNull
    public SeparatorContextMenuEntry addSeparatorEntryAfter(@NotNull String addAfterIdentifier, @NotNull String identifier) {
        SeparatorContextMenuEntry e = new SeparatorContextMenuEntry(identifier, this);
        return this.addEntryAfter(addAfterIdentifier, e);
    }

    @NotNull
    public SeparatorContextMenuEntry addSeparatorEntry(@NotNull String identifier) {
        SeparatorContextMenuEntry e = new SeparatorContextMenuEntry(identifier, this);
        return this.addEntry(e);
    }

    @NotNull
    public <T> ValueCycleContextMenuEntry<T> addValueCycleEntryAt(int index, @NotNull String identifier, @NotNull ILocalizedValueCycle<T> valueCycle) {
        ValueCycleContextMenuEntry<T> e = new ValueCycleContextMenuEntry<T>(identifier, this, valueCycle);
        return this.addEntryAt(index, e);
    }

    @NotNull
    public <T> ValueCycleContextMenuEntry<T> addValueCycleEntryAfter(@NotNull String addAfterIdentifier, @NotNull String identifier, @NotNull ILocalizedValueCycle<T> valueCycle) {
        ValueCycleContextMenuEntry<T> e = new ValueCycleContextMenuEntry<T>(identifier, this, valueCycle);
        return this.addEntryAfter(addAfterIdentifier, e);
    }

    @NotNull
    public <T> ValueCycleContextMenuEntry<T> addValueCycleEntryBefore(@NotNull String addBeforeIdentifier, @NotNull String identifier, @NotNull ILocalizedValueCycle<T> valueCycle) {
        ValueCycleContextMenuEntry<T> e = new ValueCycleContextMenuEntry<T>(identifier, this, valueCycle);
        return this.addEntryBefore(addBeforeIdentifier, e);
    }

    @NotNull
    public <T> ValueCycleContextMenuEntry<T> addValueCycleEntry(@NotNull String identifier, @NotNull ILocalizedValueCycle<T> valueCycle) {
        ValueCycleContextMenuEntry<T> e = new ValueCycleContextMenuEntry<T>(identifier, this, valueCycle);
        return this.addEntry(e);
    }

    @NotNull
    public ClickableContextMenuEntry<?> addClickableEntryAt(int index, @NotNull String identifier, @NotNull class_2561 label, @NotNull ClickableContextMenuEntry.ClickAction clickAction) {
        ClickableContextMenuEntry e = new ClickableContextMenuEntry(identifier, this, label, clickAction);
        return this.addEntryAt(index, e);
    }

    @NotNull
    public ClickableContextMenuEntry<?> addClickableEntryAfter(@NotNull String addAfterIdentifier, @NotNull String identifier, @NotNull class_2561 label, @NotNull ClickableContextMenuEntry.ClickAction clickAction) {
        ClickableContextMenuEntry e = new ClickableContextMenuEntry(identifier, this, label, clickAction);
        return this.addEntryAfter(addAfterIdentifier, e);
    }

    @NotNull
    public ClickableContextMenuEntry<?> addClickableEntryBefore(@NotNull String addBeforeIdentifier, @NotNull String identifier, @NotNull class_2561 label, @NotNull ClickableContextMenuEntry.ClickAction clickAction) {
        ClickableContextMenuEntry e = new ClickableContextMenuEntry(identifier, this, label, clickAction);
        return this.addEntryBefore(addBeforeIdentifier, e);
    }

    @NotNull
    public ClickableContextMenuEntry<?> addClickableEntry(@NotNull String identifier, @NotNull class_2561 label, @NotNull ClickableContextMenuEntry.ClickAction clickAction) {
        ClickableContextMenuEntry e = new ClickableContextMenuEntry(identifier, this, label, clickAction);
        return this.addEntry(e);
    }

    @NotNull
    public <T extends ContextMenuEntry<?>> T addEntryAfter(@NotNull String identifier, @NotNull T entry) {
        int index = this.getEntryIndex(identifier);
        if (index >= 0) {
            ++index;
        } else {
            LOGGER.error("[FANCYMENU] Failed to add ContextMenu entry (" + entry.identifier + ") after other entry (" + identifier + ")! Target entry not found! Will add the entry at the end instead!");
            index = this.entries.size();
        }
        return this.addEntryAt(index, entry);
    }

    @NotNull
    public <T extends ContextMenuEntry<?>> T addEntryBefore(@NotNull String identifier, @NotNull T entry) {
        int index = this.getEntryIndex(identifier);
        if (index < 0) {
            LOGGER.error("[FANCYMENU] Failed to add ContextMenu entry (" + entry.identifier + ") before other entry (" + identifier + ")! Target entry not found! Will add the entry at the end instead!");
            index = this.entries.size();
        }
        return this.addEntryAt(index, entry);
    }

    @NotNull
    public <T extends ContextMenuEntry<?>> T addEntry(@NotNull T entry) {
        return this.addEntryAt(this.entries.size(), entry);
    }

    @NotNull
    public <T extends ContextMenuEntry<?>> T addEntryAt(int index, @NotNull T entry) {
        if (this.hasEntry(entry.identifier)) {
            LOGGER.error("[FANCYMENU] Failed to add ContextMenu entry! Identifier already in use: " + entry.identifier);
        } else {
            this.entries.add(index, entry);
        }
        return entry;
    }

    public ContextMenu removeEntry(String identifier) {
        ContextMenuEntry<?> e = this.getEntry(identifier);
        if (e != null) {
            this.entries.remove(e);
            e.onRemoved();
        }
        return this;
    }

    public ContextMenu clearEntries() {
        this.closeMenu();
        for (ContextMenuEntry<?> e : this.entries) {
            e.onRemoved();
        }
        this.entries.clear();
        return this;
    }

    @Nullable
    public ContextMenuEntry<?> getEntry(String identifier) {
        for (ContextMenuEntry<?> e : this.entries) {
            if (!e.identifier.equals(identifier)) continue;
            return e;
        }
        return null;
    }

    public int getEntryIndex(String identifier) {
        ContextMenuEntry<?> e = this.getEntry(identifier);
        if (e != null) {
            return this.entries.indexOf(e);
        }
        return -1;
    }

    @NotNull
    public List<ContextMenuEntry<?>> getEntries() {
        return new ArrayList(this.entries);
    }

    public boolean hasEntry(String identifier) {
        return this.getEntry(identifier) != null;
    }

    public float getScale() {
        return this.scale;
    }

    public ContextMenu setScale(float scale) {
        if (this.forceUIScale) {
            LOGGER.error("[FANCYMENU] Unable to set scale of ContextMenu while ContextMenu#isForceUIScale()!");
        }
        this.scale = scale;
        return this;
    }

    public boolean isForceUIScale() {
        return this.forceUIScale;
    }

    public ContextMenu setForceUIScale(boolean forceUIScale) {
        this.forceUIScale = forceUIScale;
        return this;
    }

    protected float getMinDistanceToScreenEdge() {
        if (!this.keepDistanceToEdges) {
            return 0.0f;
        }
        return 5.0f;
    }

    protected float getActualX() {
        if (this.isSubMenu()) {
            float cachedScale = this.parentEntry.parent.scale;
            float scale = UIBase.calculateFixedScale(this.scale);
            float scaledOffsetX = 5.0f * scale;
            SubMenuOpeningSide side = this.getPossibleSubMenuOpeningSide();
            if (side == SubMenuOpeningSide.LEFT) {
                float actualX = this.parentEntry.parent.getActualX() - this.getScaledWidth() + scaledOffsetX;
                this.parentEntry.parent.scale = cachedScale;
                return actualX;
            }
            if (side == SubMenuOpeningSide.RIGHT) {
                float actualX = this.parentEntry.parent.getActualX() + this.parentEntry.parent.getScaledWidth() - scaledOffsetX;
                this.parentEntry.parent.scale = cachedScale;
                return actualX;
            }
        }
        if (this.forceRawXY) {
            return this.getX();
        }
        if (this.getX() + this.getScaledWidthWithBorder() >= (float)ContextMenu.getScreenWidth() - this.getMinDistanceToScreenEdge()) {
            return (float)ContextMenu.getScreenWidth() - this.getScaledWidthWithBorder() - this.getMinDistanceToScreenEdge() - 1.0f;
        }
        return Math.max(this.getX(), this.getMinDistanceToScreenEdge());
    }

    protected float getActualY() {
        float y = this.getY();
        if (this.isSubMenu()) {
            float scale = UIBase.calculateFixedScale(this.scale);
            int scaledOffsetY = (int)(10.0f * scale);
            y = this.parentEntry.y * scale;
            y += (float)scaledOffsetY;
        }
        if (this.forceRawXY) {
            return y;
        }
        if (y + this.getScaledHeightWithBorder() >= (float)ContextMenu.getScreenHeight() - this.getMinDistanceToScreenEdge()) {
            return (float)ContextMenu.getScreenHeight() - this.getScaledHeightWithBorder() - this.getMinDistanceToScreenEdge() - 1.0f;
        }
        return Math.max(y, this.getMinDistanceToScreenEdge());
    }

    @NotNull
    protected SubMenuOpeningSide getPossibleSubMenuOpeningSide() {
        if (this.forceSide) {
            return this.subMenuOpeningSide;
        }
        if (this.isSubMenu()) {
            float potentialX = this.parentEntry.parent.getActualX() - this.getScaledWidth() + 5.0f;
            if (this.subMenuOpeningSide == SubMenuOpeningSide.LEFT && potentialX < 5.0f) {
                return SubMenuOpeningSide.RIGHT;
            }
            potentialX = this.parentEntry.parent.getActualX() + this.parentEntry.parent.getScaledWidth() - 5.0f + this.getScaledWidth();
            if (this.subMenuOpeningSide == SubMenuOpeningSide.RIGHT && potentialX > (float)(ContextMenu.getScreenWidth() - 5)) {
                return SubMenuOpeningSide.LEFT;
            }
        }
        return this.subMenuOpeningSide;
    }

    public float getBorderThickness() {
        return 1.0f;
    }

    public float getScaledBorderThickness() {
        float scale = UIBase.calculateFixedScale(this.scale);
        return this.getBorderThickness() * scale;
    }

    public float getX() {
        return this.rawX;
    }

    public float getY() {
        return this.rawY;
    }

    public float getWidth() {
        return this.rawWidth;
    }

    public float getWidthWithBorder() {
        return this.getWidth() + this.getBorderThickness() * 2.0f;
    }

    public float getScaledWidth() {
        float scale = UIBase.calculateFixedScale(this.scale);
        return this.getWidth() * scale;
    }

    public float getScaledWidthWithBorder() {
        return this.getScaledWidth() + this.getScaledBorderThickness() * 2.0f;
    }

    public float getHeight() {
        return this.rawHeight;
    }

    public float getHeightWithBorder() {
        return this.getHeight() + this.getBorderThickness() * 2.0f;
    }

    public float getScaledHeight() {
        float scale = UIBase.calculateFixedScale(this.scale);
        return this.getHeight() * scale;
    }

    public float getScaledHeightWithBorder() {
        return this.getScaledHeight() + this.getScaledBorderThickness() * 2.0f;
    }

    public boolean isHovered() {
        if (!this.isOpen()) {
            return false;
        }
        for (ContextMenuEntry<?> e : this.entries) {
            if (!e.isHovered()) continue;
            return true;
        }
        return false;
    }

    protected ContextMenu unhoverAllEntries() {
        for (ContextMenuEntry<?> e : this.entries) {
            e.setHovered(false);
        }
        return this;
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public ContextMenu setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean isForceDefaultTooltipStyle() {
        return this.forceDefaultTooltipStyle;
    }

    public ContextMenu setForceDefaultTooltipStyle(boolean forceDefaultTooltipStyle) {
        this.forceDefaultTooltipStyle = forceDefaultTooltipStyle;
        return this;
    }

    public boolean isKeepDistanceToEdges() {
        return this.keepDistanceToEdges;
    }

    public ContextMenu setKeepDistanceToEdges(boolean keepDistanceToEdges) {
        this.keepDistanceToEdges = keepDistanceToEdges;
        return this;
    }

    public boolean isForceRawXY() {
        return this.forceRawXY;
    }

    public ContextMenu setForceRawXY(boolean forceRawXY) {
        this.forceRawXY = forceRawXY;
        return this;
    }

    public boolean isForceSide() {
        return this.forceSide;
    }

    public ContextMenu setForceSide(boolean forceSide) {
        this.forceSide = forceSide;
        return this;
    }

    public boolean isForceSideSubMenus() {
        return this.forceSideSubMenus;
    }

    public ContextMenu setForceSideSubMenus(boolean forceSideSubMenus) {
        this.forceSideSubMenus = forceSideSubMenus;
        return this;
    }

    @NotNull
    public SubMenuOpeningSide getSubMenuOpeningSide() {
        return this.subMenuOpeningSide;
    }

    public ContextMenu setSubMenuOpeningSide(@NotNull SubMenuOpeningSide subMenuOpeningSide) {
        Objects.requireNonNull(subMenuOpeningSide);
        this.subMenuOpeningSide = subMenuOpeningSide;
        return this;
    }

    public boolean isSubMenu() {
        return this.parentEntry != null;
    }

    @Nullable
    public SubMenuContextMenuEntry getParentEntry() {
        return this.parentEntry;
    }

    public boolean isSubMenuHovered() {
        if (!this.isOpen()) {
            return false;
        }
        for (ContextMenuEntry<?> e : this.entries) {
            if (!(e instanceof SubMenuContextMenuEntry)) continue;
            SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
            if (!s.subContextMenu.isHovered()) continue;
            return true;
        }
        return false;
    }

    public boolean isSubMenuOpen() {
        if (!this.isOpen()) {
            return false;
        }
        for (ContextMenuEntry<?> e : this.entries) {
            if (!(e instanceof SubMenuContextMenuEntry)) continue;
            SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
            if (!s.subContextMenu.isOpen()) continue;
            return true;
        }
        return false;
    }

    public ContextMenu openMenuAt(float x, float y, @Nullable List<String> entryPath) {
        String firstId;
        ContextMenuEntry<?> entry;
        this.closeSubMenus();
        this.unhoverAllEntries();
        this.rawX = x;
        this.rawY = y;
        this.open = true;
        if (entryPath != null && !entryPath.isEmpty() && (entry = this.getEntry(firstId = entryPath.get(0))) instanceof SubMenuContextMenuEntry) {
            SubMenuContextMenuEntry sub = (SubMenuContextMenuEntry)entry;
            sub.openSubMenu(entryPath.size() > 1 ? entryPath.subList(1, entryPath.size()) : null);
        }
        return this;
    }

    public ContextMenu openMenuAt(float x, float y) {
        return this.openMenuAt(x, y, null);
    }

    public ContextMenu openMenuAtMouse(@Nullable List<String> entryPath) {
        return this.openMenuAt(MouseInput.getMouseX(), MouseInput.getMouseY(), entryPath);
    }

    public ContextMenu openMenuAtMouse() {
        return this.openMenuAtMouse(null);
    }

    public ContextMenu closeMenu() {
        this.closeSubMenus();
        this.unhoverAllEntries();
        this.open = false;
        return this;
    }

    public ContextMenu closeSubMenus() {
        for (ContextMenuEntry<?> e : this.entries) {
            if (!(e instanceof SubMenuContextMenuEntry)) continue;
            SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
            s.subContextMenu.closeMenu();
        }
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isUserNavigatingInMenu() {
        return this.isHovered() || this.isUserNavigatingInSubMenu();
    }

    public boolean isUserNavigatingInSubMenu() {
        for (ContextMenuEntry<?> e : this.entries) {
            if (!(e instanceof SubMenuContextMenuEntry)) continue;
            SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
            if (!s.subContextMenu.isUserNavigatingInMenu()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<ContextMenuEntry<?>> getStackableEntries() {
        ArrayList l = new ArrayList();
        for (ContextMenuEntry<?> e : this.entries) {
            if (!e.isStackable()) continue;
            l.add(e);
        }
        return l;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isUserNavigatingInMenu()) {
            float scale = UIBase.calculateFixedScale(this.scale);
            int scaledMouseX = (int)((float)mouseX / scale);
            int scaledMouseY = (int)((float)mouseY / scale);
            for (ContextMenuEntry<?> entry : this.entries) {
                entry.method_25402(scaledMouseX, scaledMouseY, button);
            }
            for (ContextMenuEntry<?> e : this.entries) {
                if (!(e instanceof SubMenuContextMenuEntry)) continue;
                SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
                s.subContextMenu.method_25402(mouseX, mouseY, button);
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25365(boolean var1) {
    }

    public boolean method_25370() {
        return false;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("ContextMenus are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("ContextMenus are not navigatable!");
    }

    protected static int getScreenWidth() {
        class_437 s = class_310.method_1551().field_1755;
        if (s != null) {
            return s.field_22789;
        }
        return 1;
    }

    protected static int getScreenHeight() {
        class_437 s = class_310.method_1551().field_1755;
        if (s != null) {
            return s.field_22790;
        }
        return 1;
    }

    @NotNull
    public static ContextMenu stackContextMenus(@NotNull List<ContextMenu> menusToStack) {
        return ContextMenu.stackContextMenus(menusToStack.toArray(new ContextMenu[0]));
    }

    @NotNull
    public static ContextMenu stackContextMenus(ContextMenu ... menusToStack) {
        ContextMenu stacked = new ContextMenu();
        if (menusToStack.length > 0) {
            stacked.scale = menusToStack[0].scale;
            stacked.subMenuOpeningSide = menusToStack[0].subMenuOpeningSide;
            stacked.shadow = menusToStack[0].shadow;
            stacked.forceDefaultTooltipStyle = menusToStack[0].forceDefaultTooltipStyle;
            stacked.forceUIScale = menusToStack[0].forceUIScale;
            stacked.keepDistanceToEdges = menusToStack[0].keepDistanceToEdges;
            stacked.forceRawXY = menusToStack[0].forceRawXY;
            stacked.forceSide = menusToStack[0].forceSide;
            for (ContextMenuEntry<?> ignoredEntry : menusToStack[0].getStackableEntries()) {
                RuntimePropertyContainer stackProperties = new RuntimePropertyContainer();
                List<ContextMenuEntry<?>> entryStack = ContextMenu.collectInstancesOfStackableEntryInMenus(ignoredEntry.identifier, menusToStack);
                if (entryStack.isEmpty() || entryStack.size() != menusToStack.length) continue;
                ContextMenuEntry<?> firstOriginal = entryStack.get(0);
                ArrayList entryStackCopyWithoutFirst = new ArrayList();
                entryStack.forEach(entry -> {
                    if (entry != firstOriginal) {
                        entryStackCopyWithoutFirst.add(entry.copy());
                    }
                });
                ContextMenuEntry first = firstOriginal.copy();
                first.stackMeta.firstInStack = true;
                first.stackMeta.lastInStack = false;
                first.stackMeta.partOfStack = true;
                first.stackMeta.properties = stackProperties;
                first.parent = stacked;
                stacked.addEntry(first);
                if (first instanceof SubMenuContextMenuEntry) {
                    SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)first;
                    s.setSubContextMenu(ContextMenu.stackContextMenus(ContextMenu.getSubContextMenusOfSubMenuEntries(entryStack)));
                    s.stackMeta.lastInStack = true;
                    continue;
                }
                ContextMenuEntry prev = first;
                Iterator iterator = entryStackCopyWithoutFirst.iterator();
                while (iterator.hasNext()) {
                    ContextMenuEntry e2;
                    prev.stackMeta.nextInStack = e2 = (ContextMenuEntry)iterator.next();
                    prev = e2;
                    e2.stackMeta.properties = stackProperties;
                    e2.stackMeta.partOfStack = true;
                    e2.stackMeta.firstInStack = false;
                    e2.stackMeta.lastInStack = false;
                    e2.parent = stacked;
                }
                prev.stackMeta.lastInStack = true;
            }
        }
        return stacked;
    }

    protected static List<ContextMenuEntry<?>> collectInstancesOfStackableEntryInMenus(String entryIdentifier, ContextMenu[] menus) {
        ArrayList entries = new ArrayList();
        for (ContextMenu m : menus) {
            ContextMenuEntry<?> e = m.getEntry(entryIdentifier);
            if (e == null || !e.isStackable() || !e.isActive()) continue;
            entries.add(e);
        }
        return entries;
    }

    protected static List<ContextMenu> getSubContextMenusOfSubMenuEntries(List<ContextMenuEntry<?>> entries) {
        ArrayList<ContextMenu> l = new ArrayList<ContextMenu>();
        for (ContextMenuEntry<?> e : entries) {
            if (!(e instanceof SubMenuContextMenuEntry)) continue;
            SubMenuContextMenuEntry s = (SubMenuContextMenuEntry)e;
            l.add(s.subContextMenu);
        }
        return l;
    }

    public static class SubMenuContextMenuEntry
    extends ClickableContextMenuEntry<SubMenuContextMenuEntry> {
        @NotNull
        protected ContextMenu subContextMenu;
        protected boolean subMenuHoverTicked = false;
        protected boolean subMenuHoveredAfterOpen = false;
        protected long parentMenuHoverStartTime = -1L;
        protected long entryHoverStartTime = -1L;
        protected long entryNotHoveredStartTime = -1L;

        public SubMenuContextMenuEntry(@NotNull String identifier, @NotNull ContextMenu parent, @NotNull class_2561 label, @NotNull ContextMenu subContextMenu) {
            super(identifier, parent, label, (ContextMenu menu, ClickableContextMenuEntry<?> entry) -> {});
            this.subContextMenu = subContextMenu;
            this.subContextMenu.parentEntry = this;
            this.subContextMenu.forceDefaultTooltipStyle = parent.forceDefaultTooltipStyle;
            this.clickAction = (menu, entry) -> this.openSubMenu();
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.tickEntry();
            super.method_25394(graphics, mouseX, mouseY, partial);
            this.renderSubMenuArrow(graphics);
        }

        protected void renderSubMenuArrow(class_332 graphics) {
            RenderSystem.enableBlend();
            graphics.method_25291(class_1921::method_62277, SUB_CONTEXT_MENU_ARROW_ICON, (int)(this.x + this.width - 20.0f), (int)(this.y + 5.0f), 0.0f, 0.0f, 10, 10, 10, 10, UIBase.getUIColorTheme().ui_texture_color.getColorInt());
        }

        @Override
        protected int getTooltipIconX() {
            return super.getTooltipIconX() - 15;
        }

        @Override
        protected void renderBackground(@NotNull class_332 graphics) {
            boolean hover = this.hovered;
            this.hovered = this.hovered || this.subContextMenu.isOpen();
            super.renderBackground(graphics);
            this.hovered = hover;
        }

        protected void tickEntry() {
            long now;
            if (!this.subContextMenu.isOpen()) {
                this.subMenuHoveredAfterOpen = false;
                this.subMenuHoverTicked = false;
            }
            if (this.subContextMenu.isHovered()) {
                if (!this.subMenuHoverTicked) {
                    this.subMenuHoverTicked = true;
                } else {
                    this.subMenuHoveredAfterOpen = true;
                }
            }
            if (this.parent.isHovered() && !this.isHovered() && this.subContextMenu.isOpen() && !this.subContextMenu.isUserNavigatingInMenu() && this.subMenuHoveredAfterOpen) {
                if (this.parentMenuHoverStartTime == -1L) {
                    this.parentMenuHoverStartTime = System.currentTimeMillis();
                }
                if (this.parentMenuHoverStartTime + 400L < System.currentTimeMillis()) {
                    this.subContextMenu.closeMenu();
                }
            } else {
                this.parentMenuHoverStartTime = -1L;
            }
            if (this.isActive() && this.isHovered() && !this.parent.isSubMenuHovered() && !this.tooltipIconHovered) {
                int openSpeed;
                now = System.currentTimeMillis();
                if (this.entryHoverStartTime == -1L) {
                    this.entryHoverStartTime = now;
                }
                if (this.entryHoverStartTime + (long)(openSpeed = 400 / Math.max(1, FancyMenu.getOptions().contextMenuHoverOpenSpeed.getValue())) < now && !this.subContextMenu.isOpen()) {
                    this.parent.closeSubMenus();
                    this.openSubMenu();
                }
            } else {
                this.entryHoverStartTime = -1L;
            }
            if (!this.isHovered() && this.parent.isHovered() && !this.parent.isSubMenuHovered()) {
                now = System.currentTimeMillis();
                if (this.entryNotHoveredStartTime == -1L) {
                    this.entryNotHoveredStartTime = now;
                }
                if (this.entryNotHoveredStartTime + 400L < now && this.subContextMenu.isOpen()) {
                    this.subContextMenu.closeMenu();
                }
            } else {
                this.entryNotHoveredStartTime = -1L;
            }
            if (this.tooltipActive && this.subContextMenu.isOpen()) {
                this.subContextMenu.closeMenu();
            }
        }

        public void openSubMenu(@NotNull List<String> entryPath) {
            this.subContextMenu.openMenuAt(0.0f, 0.0f, entryPath);
        }

        public void openSubMenu() {
            this.subContextMenu.openMenuAt(0.0f, 0.0f);
        }

        @NotNull
        public ContextMenu getSubContextMenu() {
            return this.subContextMenu;
        }

        public void setSubContextMenu(@NotNull ContextMenu subContextMenu) {
            this.subContextMenu.closeMenu();
            this.subContextMenu.parentEntry = null;
            this.subContextMenu = subContextMenu;
            this.subContextMenu.parentEntry = this;
            this.subContextMenu.forceDefaultTooltipStyle = this.parent.forceDefaultTooltipStyle;
        }

        @NotNull
        public SubMenuOpeningSide getSubMenuOpeningSide() {
            return this.subContextMenu.subMenuOpeningSide;
        }

        public SubMenuContextMenuEntry setSubMenuOpeningSide(@NotNull SubMenuOpeningSide subMenuOpeningSide) {
            this.subContextMenu.subMenuOpeningSide = subMenuOpeningSide;
            return this;
        }

        @Override
        public SubMenuContextMenuEntry copy() {
            SubMenuContextMenuEntry copy = new SubMenuContextMenuEntry(this.identifier, this.parent, (class_2561)class_2561.method_43470((String)""), new ContextMenu());
            copy.height = this.height;
            copy.tickAction = this.tickAction;
            copy.tooltipSupplier = this.tooltipSupplier;
            copy.activeStateSuppliers = new ArrayList(this.activeStateSuppliers);
            copy.labelSupplier = this.labelSupplier;
            copy.icon = this.icon;
            return copy;
        }

        @Override
        protected void onRemoved() {
            this.subContextMenu.closeMenu();
            this.subContextMenu.parentEntry = null;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0 && this.subContextMenu.isOpen() && !this.subContextMenu.isUserNavigatingInMenu()) {
                this.subContextMenu.closeMenu();
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public float getMinWidth() {
            float i = super.getMinWidth();
            i = this.tooltipSupplier == null ? (i += 30.0f) : (i += 15.0f);
            return i;
        }

        @Override
        @NotNull
        public SubMenuContextMenuEntry setClickAction(@NotNull ClickableContextMenuEntry.ClickAction clickAction) {
            LOGGER.error("[FANCYMENU] You can't set the click action of SubMenuContextMenuEntries.");
            return this;
        }

        @Override
        @NotNull
        public SubMenuContextMenuEntry setShortcutTextSupplier(@Nullable Supplier<class_2561> shortcutTextSupplier) {
            LOGGER.error("[FANCYMENU] You can't set a shortcut text for SubMenuContextMenuEntries.");
            return this;
        }
    }

    public static enum SubMenuOpeningSide {
        LEFT,
        RIGHT;

    }

    public static class SpacerContextMenuEntry
    extends ContextMenuEntry<SpacerContextMenuEntry> {
        public SpacerContextMenuEntry(@NotNull String identifier, @NotNull ContextMenu parent) {
            super(identifier, parent);
            this.height = 4.0f;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        }

        @Override
        public float getMinWidth() {
            int i = 20;
            if (this.addSpaceForIcon) {
                i += 20;
            }
            return i;
        }

        public SpacerContextMenuEntry copy() {
            SpacerContextMenuEntry e = new SpacerContextMenuEntry(this.identifier, this.parent);
            e.height = this.height;
            return e;
        }

        public void method_25365(boolean var1) {
        }

        public boolean method_25370() {
            return false;
        }
    }

    public static abstract class ContextMenuEntry<T extends ContextMenuEntry<T>>
    implements class_4068,
    class_364 {
        protected String identifier;
        protected ContextMenu parent;
        protected float x;
        protected float y;
        protected float width;
        protected float height = 20.0f;
        @Nullable
        protected EntryTask tickAction;
        protected EntryTask hoverAction;
        protected boolean hovered = false;
        protected ContextMenuStackMeta stackMeta = new ContextMenuStackMeta();
        protected List<BooleanSupplier> activeStateSuppliers = new ArrayList<BooleanSupplier>();
        protected List<BooleanSupplier> visibleStateSuppliers = new ArrayList<BooleanSupplier>();
        @Nullable
        protected Supplier<Tooltip> tooltipSupplier;
        protected class_327 font;
        protected boolean addSpaceForIcon;
        protected boolean changeBackgroundColorOnHover;

        public ContextMenuEntry(@NotNull String identifier, @NotNull ContextMenu parent) {
            this.font = class_310.method_1551().field_1772;
            this.addSpaceForIcon = false;
            this.changeBackgroundColorOnHover = true;
            this.identifier = identifier;
            this.parent = parent;
        }

        public abstract void method_25394(@NotNull class_332 var1, int var2, int var3, float var4);

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        @NotNull
        public ContextMenu getParent() {
            return this.parent;
        }

        public float getHeight() {
            return this.height;
        }

        public T setHeight(float height) {
            this.height = height;
            return (T)this;
        }

        public abstract float getMinWidth();

        protected void setHovered(boolean hovered) {
            this.hovered = hovered;
        }

        public boolean isHovered() {
            if (!this.parent.isOpen()) {
                return false;
            }
            return this.hovered;
        }

        public boolean isChangeBackgroundColorOnHover() {
            return this.changeBackgroundColorOnHover;
        }

        public T setChangeBackgroundColorOnHover(boolean changeColor) {
            this.changeBackgroundColorOnHover = changeColor;
            return (T)this;
        }

        public boolean isActive() {
            for (BooleanSupplier b : this.activeStateSuppliers) {
                if (b.getBoolean(this.parent, this)) continue;
                return false;
            }
            return true;
        }

        @Deprecated(forRemoval=true)
        public T setIsActiveSupplier(@Nullable BooleanSupplier activeStateSupplier) {
            if (activeStateSupplier != null) {
                this.addIsActiveSupplier(activeStateSupplier);
            }
            return (T)this;
        }

        public T addIsActiveSupplier(@NotNull BooleanSupplier activeStateSupplier) {
            this.activeStateSuppliers.add(Objects.requireNonNull(activeStateSupplier));
            return (T)this;
        }

        public boolean isVisible() {
            for (BooleanSupplier b : this.visibleStateSuppliers) {
                if (b.getBoolean(this.parent, this)) continue;
                return false;
            }
            return true;
        }

        @Deprecated(forRemoval=true)
        public T setIsVisibleSupplier(@Nullable BooleanSupplier visibleStateSupplier) {
            if (visibleStateSupplier != null) {
                this.addIsVisibleSupplier(visibleStateSupplier);
            }
            return (T)this;
        }

        public T addIsVisibleSupplier(@NotNull BooleanSupplier visibleStateSupplier) {
            this.visibleStateSuppliers.add(Objects.requireNonNull(visibleStateSupplier));
            return (T)this;
        }

        public T setTickAction(@Nullable EntryTask tickAction) {
            this.tickAction = tickAction;
            return (T)this;
        }

        public T setHoverAction(@Nullable EntryTask hoverAction) {
            this.hoverAction = hoverAction;
            return (T)this;
        }

        public T setTooltipSupplier(@Nullable Supplier<Tooltip> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return (T)this;
        }

        @Nullable
        public Tooltip getTooltip() {
            return this.tooltipSupplier != null ? this.tooltipSupplier.get(this.parent, this) : null;
        }

        public T setStackable(boolean stackable) {
            this.getStackMeta().setStackable(stackable);
            return (T)this;
        }

        public boolean isStackable() {
            return this.getStackMeta().isStackable();
        }

        @NotNull
        public ContextMenuStackMeta getStackMeta() {
            return this.stackMeta;
        }

        protected void onRemoved() {
        }

        public abstract ContextMenuEntry<?> copy();

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return super.method_25402(mouseX, mouseY, button);
        }

        @FunctionalInterface
        public static interface EntryTask {
            public void run(ContextMenu var1, ContextMenuEntry<?> var2, boolean var3);
        }
    }

    public static class ClickableContextMenuEntry<T extends ClickableContextMenuEntry<T>>
    extends ContextMenuEntry<T> {
        protected static final int ICON_WIDTH_HEIGHT = 10;
        @NotNull
        protected ClickAction clickAction;
        @NotNull
        protected Supplier<class_2561> labelSupplier;
        @Nullable
        protected Supplier<class_2561> shortcutTextSupplier;
        @Nullable
        protected class_2960 icon;
        protected boolean tooltipIconHovered = false;
        protected boolean tooltipActive = false;
        protected long tooltipIconHoverStart = -1L;
        protected boolean enableClickSound = true;

        public ClickableContextMenuEntry(@NotNull String identifier, @NotNull ContextMenu parent, @NotNull class_2561 label, @NotNull ClickAction clickAction) {
            super(identifier, parent);
            this.clickAction = clickAction;
            this.labelSupplier = (menu, entry) -> label;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.renderBackground(graphics);
            int labelX = (int)(this.x + 10.0f);
            if (this.icon != null || this.addSpaceForIcon) {
                labelX += 20;
            }
            float f = this.y + this.height / 2.0f;
            Objects.requireNonNull(this.font);
            int labelY = (int)(f - (float)(9 / 2));
            UIBase.drawElementLabel(graphics, this.font, this.getLabel(), labelX, labelY, this.isActive() ? UIBase.getUIColorTheme().element_label_color_normal.getColorInt() : UIBase.getUIColorTheme().element_label_color_inactive.getColorInt());
            int shortcutTextWidth = 0;
            class_2561 shortcutText = this.getShortcutText();
            if (shortcutText != null) {
                shortcutTextWidth = this.font.method_27525((class_5348)shortcutText);
                int shortcutX = (int)(this.x + this.width - 10.0f - (float)shortcutTextWidth);
                UIBase.drawElementLabel(graphics, this.font, shortcutText, shortcutX, labelY, this.isActive() ? UIBase.getUIColorTheme().element_label_color_normal.getColorInt() : UIBase.getUIColorTheme().element_label_color_inactive.getColorInt());
            }
            this.renderIcon(graphics);
            this.renderTooltipIconAndRegisterTooltip(graphics, mouseX, mouseY, shortcutTextWidth > 0 ? -(shortcutTextWidth + 8) : 0);
        }

        protected void renderIcon(class_332 graphics) {
            if (this.icon != null) {
                RenderSystem.enableBlend();
                graphics.method_25291(class_1921::method_62277, this.icon, (int)(this.x + 10.0f), (int)(this.y + this.getHeight() / 2.0f - 5.0f), 0.0f, 0.0f, 10, 10, 10, 10, UIBase.getUIColorTheme().ui_texture_color.getColorInt());
            }
        }

        protected void renderTooltipIconAndRegisterTooltip(class_332 graphics, int mouseX, int mouseY, int offsetX) {
            Tooltip tooltip = this.getTooltip();
            if (tooltip != null) {
                this.tooltipIconHovered = this.isTooltipIconHovered(mouseX, mouseY, offsetX);
                if (this.tooltipIconHovered) {
                    if (this.tooltipIconHoverStart == -1L) {
                        this.tooltipIconHoverStart = System.currentTimeMillis();
                    }
                } else {
                    this.tooltipIconHoverStart = -1L;
                }
                this.tooltipActive = this.tooltipIconHoverStart != -1L && this.tooltipIconHoverStart + 200L < System.currentTimeMillis();
                RenderSystem.enableBlend();
                graphics.method_25291(class_1921::method_62277, CONTEXT_MENU_TOOLTIP_ICON, this.getTooltipIconX() + offsetX, this.getTooltipIconY(), 0.0f, 0.0f, 10, 10, 10, 10, UIBase.getUIColorTheme().ui_texture_color.getColorIntWithAlpha(this.tooltipIconHovered ? 1.0f : 0.2f));
                if (this.tooltipActive) {
                    if (this.parent.isForceDefaultTooltipStyle()) {
                        tooltip.setDefaultStyle();
                    }
                    tooltip.setScale(Float.valueOf(this.parent.scale));
                    TooltipHandler.INSTANCE.addTooltip(tooltip, () -> this.tooltipActive, false, true);
                }
            } else {
                this.tooltipIconHovered = false;
                this.tooltipActive = false;
            }
        }

        protected boolean isTooltipIconHovered(int mouseX, int mouseY, int offsetX) {
            return UIBase.isXYInArea(mouseX, mouseY, this.getTooltipIconX() + offsetX, this.getTooltipIconY(), 10, 10);
        }

        protected int getTooltipIconX() {
            return (int)(this.x + this.width - 20.0f);
        }

        protected int getTooltipIconY() {
            return (int)(this.y + 5.0f);
        }

        protected void renderBackground(@NotNull class_332 graphics) {
            if (this.isChangeBackgroundColorOnHover() && this.isHovered() && this.isActive()) {
                RenderingUtils.fillF(graphics, this.x, this.y, this.x + this.width, this.y + this.height, UIBase.getUIColorTheme().element_background_color_hover.getColorInt());
            }
        }

        @Nullable
        public class_2960 getIcon() {
            return this.icon;
        }

        public T setIcon(@Nullable class_2960 icon) {
            this.icon = icon;
            return (T)this;
        }

        @NotNull
        public T setLabelSupplier(@NotNull Supplier<class_2561> labelSupplier) {
            Objects.requireNonNull(labelSupplier);
            this.labelSupplier = labelSupplier;
            return (T)this;
        }

        @NotNull
        public class_2561 getLabel() {
            class_2561 c = this.labelSupplier.get(this.parent, this);
            Objects.requireNonNull(c);
            return c;
        }

        @NotNull
        public T setClickAction(@NotNull ClickAction clickAction) {
            Objects.requireNonNull(clickAction);
            this.clickAction = clickAction;
            return (T)this;
        }

        @Nullable
        public class_2561 getShortcutText() {
            return this.shortcutTextSupplier != null ? this.shortcutTextSupplier.get(this.parent, this) : null;
        }

        @NotNull
        public T setShortcutTextSupplier(@Nullable Supplier<class_2561> shortcutTextSupplier) {
            this.shortcutTextSupplier = shortcutTextSupplier;
            return (T)this;
        }

        public boolean isClickSoundEnabled() {
            return this.enableClickSound;
        }

        public T setClickSoundEnabled(boolean enabled) {
            this.enableClickSound = enabled;
            return (T)this;
        }

        @Override
        public ClickableContextMenuEntry<T> copy() {
            ClickableContextMenuEntry<T> copy = new ClickableContextMenuEntry<T>(this.identifier, this.parent, (class_2561)class_2561.method_43470((String)""), this.clickAction);
            copy.shortcutTextSupplier = this.shortcutTextSupplier;
            copy.labelSupplier = this.labelSupplier;
            copy.height = this.height;
            copy.tickAction = this.tickAction;
            copy.tooltipSupplier = this.tooltipSupplier;
            copy.activeStateSuppliers = new ArrayList(this.activeStateSuppliers);
            copy.icon = this.icon;
            return copy;
        }

        @Override
        public float getMinWidth() {
            class_2561 shortcutText;
            int i = class_310.method_1551().field_1772.method_27525((class_5348)this.getLabel()) + 20;
            if (this.tooltipSupplier != null) {
                i += 30;
            }
            if ((shortcutText = this.getShortcutText()) != null) {
                i += class_310.method_1551().field_1772.method_27525((class_5348)shortcutText) + 30;
            }
            if (this.icon != null || this.addSpaceForIcon) {
                i += 20;
            }
            return i;
        }

        public void method_25365(boolean var1) {
        }

        public boolean method_25370() {
            return false;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0 && this.isHovered() && this.isActive() && !this.parent.isSubMenuHovered() && !this.tooltipIconHovered) {
                if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue() && this.enableClickSound) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
                this.clickAction.onClick(this.parent, this);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @FunctionalInterface
        public static interface ClickAction {
            public void onClick(ContextMenu var1, ClickableContextMenuEntry<?> var2);
        }
    }

    public static class SeparatorContextMenuEntry
    extends ContextMenuEntry<SeparatorContextMenuEntry> {
        public SeparatorContextMenuEntry(@NotNull String identifier, @NotNull ContextMenu parent) {
            super(identifier, parent);
            this.height = 9.0f;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            RenderingUtils.fillF(graphics, this.x + 10.0f, this.y + 4.0f, this.x + this.width - 10.0f, this.y + 5.0f, UIBase.getUIColorTheme().element_border_color_normal.getColorInt());
        }

        public SeparatorContextMenuEntry copy() {
            SeparatorContextMenuEntry copy = new SeparatorContextMenuEntry(this.identifier, this.parent);
            copy.height = this.height;
            copy.tickAction = this.tickAction;
            copy.tooltipSupplier = this.tooltipSupplier;
            copy.activeStateSuppliers = new ArrayList(this.activeStateSuppliers);
            return copy;
        }

        @Override
        public float getMinWidth() {
            int i = 20;
            if (this.addSpaceForIcon) {
                i += 20;
            }
            return i;
        }

        public void method_25365(boolean var1) {
        }

        public boolean method_25370() {
            return false;
        }
    }

    public static class ValueCycleContextMenuEntry<V>
    extends ClickableContextMenuEntry<ValueCycleContextMenuEntry<V>> {
        protected final ILocalizedValueCycle<V> valueCycle;

        public ValueCycleContextMenuEntry(@NotNull String identifier, @NotNull ContextMenu parent, @NotNull ILocalizedValueCycle<V> valueCycle) {
            super(identifier, parent, (class_2561)class_2561.method_43473(), (menu, entry) -> valueCycle.next());
            this.valueCycle = valueCycle;
            this.labelSupplier = (menu, entry) -> this.valueCycle.getCycleComponent();
        }

        @NotNull
        public ILocalizedValueCycle<V> getValueCycle() {
            return this.valueCycle;
        }

        @Override
        @NotNull
        public ValueCycleContextMenuEntry<V> setLabelSupplier(@NotNull Supplier<class_2561> labelSupplier) {
            LOGGER.error("[FANCYMENU] You can't set the label of ValueCycleContextMenuEntries!");
            return this;
        }

        @Override
        @NotNull
        public ValueCycleContextMenuEntry<V> setClickAction(@NotNull ClickableContextMenuEntry.ClickAction clickAction) {
            LOGGER.error("[FANCYMENU] You can't set the click action of ValueCycleContextMenuEntries!");
            return this;
        }

        @Override
        public ValueCycleContextMenuEntry<V> copy() {
            ValueCycleContextMenuEntry<V> copy = new ValueCycleContextMenuEntry<V>(this.identifier, this.parent, this.valueCycle);
            copy.shortcutTextSupplier = this.shortcutTextSupplier;
            copy.labelSupplier = this.labelSupplier;
            copy.height = this.height;
            copy.tickAction = this.tickAction;
            copy.tooltipSupplier = this.tooltipSupplier;
            copy.activeStateSuppliers = new ArrayList(this.activeStateSuppliers);
            copy.icon = this.icon;
            return copy;
        }
    }

    public static class ContextMenuStackMeta {
        protected RuntimePropertyContainer properties = new RuntimePropertyContainer();
        protected boolean stackable = false;
        protected boolean partOfStack = false;
        protected boolean firstInStack = true;
        protected boolean lastInStack = true;
        protected ContextMenuEntry<?> nextInStack;

        @NotNull
        public RuntimePropertyContainer getProperties() {
            return this.properties;
        }

        public boolean isPartOfStack() {
            return this.partOfStack;
        }

        public boolean isFirstInStack() {
            return this.firstInStack;
        }

        public boolean isLastInStack() {
            return this.lastInStack;
        }

        public boolean isStackable() {
            return this.stackable;
        }

        public void setStackable(boolean stackable) {
            this.stackable = stackable;
        }
    }

    public static class IconFactory {
        @NotNull
        public static class_2960 getIcon(@NotNull String iconName) {
            return class_2960.method_60655((String)"fancymenu", (String)("textures/contextmenu/icons/" + iconName + ".png"));
        }
    }

    @FunctionalInterface
    public static interface BooleanSupplier
    extends Supplier<Boolean> {
        default public boolean getBoolean(ContextMenu menu, ContextMenuEntry<?> entry) {
            Boolean b = (Boolean)this.get(menu, entry);
            if (b != null) {
                return b;
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get(ContextMenu var1, ContextMenuEntry<?> var2);
    }
}

