/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.window;

import com.mojang.blaze3d.platform.TextureUtil;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.class_310;
import net.minecraft.class_6417;
import net.minecraft.class_7367;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WindowHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleForceFullscreen() {
        try {
            if (FancyMenu.getOptions().forceFullscreen.getValue().booleanValue() && !class_310.method_1551().method_22683().method_4498()) {
                class_310.method_1551().method_22683().method_4500();
                LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isCustomWindowIconEnabled() {
        return FancyMenu.getOptions().showCustomWindowIcon.getValue();
    }

    @Nullable
    public static File getCustomWindowIcon16() {
        String path = FancyMenu.getOptions().customWindowIcon16.getValue();
        if (!path.replace(" ", "").isEmpty()) {
            return new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(path));
        }
        return null;
    }

    @Nullable
    public static File getCustomWindowIcon32() {
        String path = FancyMenu.getOptions().customWindowIcon32.getValue();
        if (!path.replace(" ", "").isEmpty()) {
            return new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(path));
        }
        return null;
    }

    @Nullable
    public static File getCustomWindowIconMacOS() {
        String path = FancyMenu.getOptions().customWindowIconMacOS.getValue();
        if (!path.replace(" ", "").isEmpty()) {
            return new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(path));
        }
        return null;
    }

    public static boolean allCustomWindowIconsSetAndFound() {
        File i16 = WindowHandler.getCustomWindowIcon16();
        File i32 = WindowHandler.getCustomWindowIcon32();
        File iMacOS = WindowHandler.getCustomWindowIconMacOS();
        return i16 != null && i32 != null && iMacOS != null && i16.isFile() && i32.isFile() && iMacOS.isFile();
    }

    public static void updateCustomWindowIcon() {
        if (class_310.field_1703) {
            WindowHandler.updateCustomWindowIconMacOS();
        } else {
            WindowHandler.updateCustomWindowIconWindowsLinux();
        }
    }

    private static void updateCustomWindowIconMacOS() {
        File iMacOS = WindowHandler.getCustomWindowIconMacOS();
        if (WindowHandler.isCustomWindowIconEnabled() && iMacOS != null) {
            try {
                if (!iMacOS.isFile()) {
                    LOGGER.error("[FANCYMENU] Unable to set custom window icons! 16x16 icon or 32x32 icon not found!");
                    return;
                }
                class_6417.method_41718((class_7367)class_7367.create((Path)iMacOS.toPath()));
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to set custom window icon!");
                ex.printStackTrace();
            }
        }
    }

    private static void updateCustomWindowIconWindowsLinux() {
        File i16 = WindowHandler.getCustomWindowIcon16();
        File i32 = WindowHandler.getCustomWindowIcon32();
        if (WindowHandler.isCustomWindowIconEnabled() && i16 != null && i32 != null) {
            try {
                if (!i16.exists() || !i32.exists()) {
                    LOGGER.error("[FANCYMENU] Unable to set custom window icons! 16x16 icon or 32x32 icon not found!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    LOGGER.error("[FANCYMENU] Unable to set custom window icons! 16x16 icon has wrong resolution! Has To be exactly 16x16 pixels!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    LOGGER.error("[FANCYMENU] Unable to set custom window icons! 32x32 icon has wrong resolution! Has To be exactly 32x32 pixels!");
                    return;
                }
                WindowHandler.setIcon((class_7367<InputStream>)class_7367.create((Path)i16.toPath()), (class_7367<InputStream>)class_7367.create((Path)i32.toPath()));
                LOGGER.info("[FANCYMENU] Custom window icon successfully updated!");
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Failed to set custom window icon!");
                e.printStackTrace();
            }
        }
    }

    protected static void setIcon(class_7367<InputStream> $$0, class_7367<InputStream> $$1) {
        try (MemoryStack $$2 = MemoryStack.stackPush();){
            IntBuffer $$3 = $$2.mallocInt(1);
            IntBuffer $$4 = $$2.mallocInt(1);
            IntBuffer $$5 = $$2.mallocInt(1);
            GLFWImage.Buffer $$6 = GLFWImage.malloc((int)2, (MemoryStack)$$2);
            ByteBuffer $$7 = WindowHandler.readIconPixels($$0, $$3, $$4, $$5);
            if ($$7 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            $$6.position(0);
            $$6.width($$3.get(0));
            $$6.height($$4.get(0));
            $$6.pixels($$7);
            ByteBuffer $$8 = WindowHandler.readIconPixels($$1, $$3, $$4, $$5);
            if ($$8 == null) {
                STBImage.stbi_image_free((ByteBuffer)$$7);
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            $$6.position(1);
            $$6.width($$3.get(0));
            $$6.height($$4.get(0));
            $$6.pixels($$8);
            $$6.position(0);
            GLFW.glfwSetWindowIcon((long)class_310.method_1551().method_22683().method_4490(), (GLFWImage.Buffer)$$6);
            STBImage.stbi_image_free((ByteBuffer)$$7);
            STBImage.stbi_image_free((ByteBuffer)$$8);
        }
        catch (IOException var12) {
            LOGGER.error("Couldn't set icon", (Throwable)var12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected static ByteBuffer readIconPixels(class_7367<InputStream> $$0, IntBuffer $$1, IntBuffer $$2, IntBuffer $$3) throws IOException {
        ByteBuffer var7;
        ByteBuffer $$4 = null;
        try {
            try (InputStream $$5 = (InputStream)$$0.get();){
                $$4 = TextureUtil.readResource((InputStream)$$5);
                $$4.rewind();
                var7 = STBImage.stbi_load_from_memory((ByteBuffer)$$4, (IntBuffer)$$1, (IntBuffer)$$2, (IntBuffer)$$3, (int)0);
            }
            if ($$4 == null) return var7;
        }
        catch (Throwable throwable) {
            if ($$4 == null) throw throwable;
            MemoryUtil.memFree($$4);
            throw throwable;
        }
        MemoryUtil.memFree((Buffer)$$4);
        return var7;
    }

    public static void resetWindowIcon() {
        try {
            if (class_310.field_1703) {
                class_6417.method_41718(WindowHandler.getVanillaWindowIconFile("icons", "minecraft.icns"));
            } else {
                WindowHandler.setIcon(WindowHandler.getVanillaWindowIconFile("icons", "icon_16x16.png"), WindowHandler.getVanillaWindowIconFile("icons", "icon_32x32.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class_7367<InputStream> getVanillaWindowIconFile(String ... $$0) throws IOException {
        class_7367 $$1 = class_310.method_1551().method_45573().method_14410($$0);
        if ($$1 == null) {
            throw new FileNotFoundException(String.join((CharSequence)"/", $$0));
        }
        return $$1;
    }

    public static void updateWindowTitle() {
        class_310.method_1551().method_24288();
    }

    @Nullable
    public static String getCustomWindowTitle() {
        String windowTitle = FancyMenu.getOptions().customWindowTitle.getValue();
        if (windowTitle.isEmpty()) {
            windowTitle = null;
        }
        return windowTitle;
    }
}

