/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.resource.entity.EntityLightSources;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record DisplayEntityLuminance(List<EntityLuminance> luminance) implements EntityLuminance
{
    public static final MapCodec<DisplayEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityLuminance.LIST_CODEC.fieldOf("luminance").forGetter(DisplayEntityLuminance::luminance)).apply((Applicative)instance, DisplayEntityLuminance::new));

    @NotNull
    public EntityLuminance.Type type() {
        return EntityLightSources.DISPLAY;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
        class_8113 display;
        if (entity instanceof class_8113 && (display = (class_8113)entity).method_48865() == -1) {
            return EntityLuminance.getLuminance((ItemLightSourceManager)itemLightSourceManager, (class_1297)entity, this.luminance);
        }
        return 0;
    }

    public static final class ItemDisplayLuminance
    implements EntityLuminance {
        public static final ItemDisplayLuminance INSTANCE = new ItemDisplayLuminance();

        private ItemDisplayLuminance() {
        }

        @NotNull
        public EntityLuminance.Type type() {
            return EntityLightSources.ITEM_DISPLAY;
        }

        public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
            if (entity instanceof class_8113.class_8122) {
                class_8113.class_8122 display = (class_8113.class_8122)entity;
                return itemLightSourceManager.getLuminance(display.method_48900(), display.method_5869());
            }
            return 0;
        }
    }

    public static final class BlockDisplayLuminance
    implements EntityLuminance {
        public static final BlockDisplayLuminance INSTANCE = new BlockDisplayLuminance();

        private BlockDisplayLuminance() {
        }

        @NotNull
        public EntityLuminance.Type type() {
            return EntityLightSources.BLOCK_DISPLAY;
        }

        public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
            if (entity instanceof class_8113.class_8115) {
                class_8113.class_8115 display = (class_8113.class_8115)entity;
                return display.method_48884().method_26213();
            }
            return 0;
        }
    }
}

