/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.spark;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.stream.Stream;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.SamplerSettings;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.java.JavaSampler;
import me.lucko.spark.common.sampler.java.MergeStrategy;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.protobuf.AbstractMessageLite;
import me.lucko.spark.proto.SparkSamplerProtos;
import net.minecraft.class_155;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;

public class SparkLaunchProfiler {
    private static PlatformInfo platformInfo = new ModernFixPlatformInfo();
    private static CommandSender commandSender = new ModernFixCommandSender();
    private static Map<String, Sampler> ongoingSamplers = new Object2ReferenceOpenHashMap();
    private static ExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("spark-modernfix-async-worker").build());
    private static final SparkPlatform platform = new SparkPlatform((SparkPlugin)new ModernFixSparkPlugin());
    private static final boolean USE_JAVA_SAMPLER_FOR_LAUNCH = true;

    public static void start(String key) {
        if (!ongoingSamplers.containsKey(key)) {
            SamplerSettings settings = new SamplerSettings(4000, ThreadDumper.ALL, (ThreadGrouper)ThreadGrouper.BY_NAME.get(), -1L, false);
            try {
                throw new UnsupportedOperationException();
            }
            catch (UnsupportedOperationException e) {
                JavaSampler sampler = new JavaSampler(platform, settings, true, true);
                ongoingSamplers.put(key, (Sampler)sampler);
                ModernFixMixinPlugin.instance.logger.warn("Profiler has started for stage [{}]...", (Object)key);
                sampler.start();
            }
        }
    }

    public static void stop(String key) {
        Sampler sampler = ongoingSamplers.remove(key);
        if (sampler != null) {
            sampler.stop(true);
            SparkLaunchProfiler.output(key, sampler);
        }
    }

    private static void output(String key, Sampler sampler) {
        executor.execute(() -> {
            ModernFixMixinPlugin.instance.logger.warn("Stage [{}] profiler has stopped! Uploading results...", (Object)key);
            SparkSamplerProtos.SamplerData output = sampler.toProto(platform, new Sampler.ExportProps().creator(new CommandSender.Data(commandSender.getName(), commandSender.getUniqueId())).comment("Stage: " + key).mergeStrategy(MergeStrategy.SAME_METHOD).classSourceLookup(() -> ((SparkPlatform)platform).createClassSourceLookup()));
            try {
                String urlKey = platform.getBytebinClient().postContent((AbstractMessageLite)output, "application/x-spark-sampler").key();
                String url = "https://spark.lucko.me/" + urlKey;
                ModernFixMixinPlugin.instance.logger.warn("Profiler results for Stage [{}]: {}", (Object)key, (Object)url);
            }
            catch (Exception e) {
                ModernFixMixinPlugin.instance.logger.fatal("An error occurred whilst uploading the results.", (Throwable)e);
            }
        });
    }

    static class ModernFixPlatformInfo
    implements PlatformInfo {
        ModernFixPlatformInfo() {
        }

        public PlatformInfo.Type getType() {
            return ModernFixPlatformHooks.INSTANCE.isClient() ? PlatformInfo.Type.CLIENT : PlatformInfo.Type.SERVER;
        }

        public String getName() {
            return ModernFixPlatformHooks.INSTANCE.getPlatformName();
        }

        public String getBrand() {
            return this.getName();
        }

        public String getVersion() {
            return ModernFixPlatformHooks.INSTANCE.getVersionString();
        }

        public String getMinecraftVersion() {
            return class_155.method_16673().method_48019();
        }
    }

    public static class ModernFixCommandSender
    implements CommandSender {
        private final UUID uuid = UUID.randomUUID();
        private final String name;

        public ModernFixCommandSender() {
            this.name = "ModernFix";
        }

        public String getName() {
            return this.name;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public boolean hasPermission(String s) {
            return true;
        }

        public void sendMessage(Component component) {
        }
    }

    static class ModernFixSparkPlugin
    implements SparkPlugin {
        ModernFixSparkPlugin() {
        }

        public String getVersion() {
            return "1.0";
        }

        public Path getPluginDirectory() {
            return ModernFixPlatformHooks.INSTANCE.getGameDirectory().resolve("spark-modernfix");
        }

        public String getCommandName() {
            return "spark-modernfix";
        }

        public Stream<? extends CommandSender> getCommandSenders() {
            return Stream.of(new CommandSender[0]);
        }

        public void executeAsync(Runnable runnable) {
            executor.execute(runnable);
        }

        public void log(Level level, String s) {
            ModernFixMixinPlugin.instance.logger.warn(s);
        }

        public PlatformInfo getPlatformInfo() {
            return platformInfo;
        }
    }
}

