/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class StackTraceSupplier
implements Supplier<String> {
    private final Throwable throwable;
    @Nullable
    private final Supplier<String> message;

    private StackTraceSupplier(@Nullable Throwable throwable, @Nullable Supplier<String> message) {
        this.throwable = throwable;
        this.message = message;
    }

    public static StackTraceSupplier of(Throwable throwable) {
        return new StackTraceSupplier(throwable, null);
    }

    public static StackTraceSupplier of(Throwable throwable, Supplier<String> supplier) {
        return new StackTraceSupplier(throwable, supplier);
    }

    public static StackTraceSupplier of(String message) {
        return new StackTraceSupplier(new IllegalStateException(message), null);
    }

    @Override
    public String get() {
        return this.message != null ? this.message.get() : this.throwable.getMessage();
    }

    public StackTraceElement[] getFullStackTrace() {
        Throwable innerThrowable = this.throwable();
        while (innerThrowable.getCause() != null) {
            innerThrowable = this.throwable().getCause();
        }
        return innerThrowable.getStackTrace();
    }

    public Throwable throwable() {
        return this.throwable;
    }

    public String toString() {
        return "StackTraceSupplier[throwable=" + String.valueOf(this.throwable) + ", message=" + String.valueOf(this.message) + "]";
    }
}

