/*
 * Decompiled with CFR 0.152.
 */
package com.plasmoverse.opus;

import com.plasmoverse.opus.OpusException;
import com.plasmoverse.opus.OpusLibrary;
import com.plasmoverse.opus.OpusMode;
import java.io.IOException;

public final class OpusEncoder {
    private final long pointer;

    public static OpusEncoder create(int sampleRate, boolean stereo, int mtuSize, OpusMode mode) throws IOException, OpusException {
        OpusLibrary.load();
        long pointer = OpusEncoder.createNative(sampleRate, stereo, mtuSize, mode.getApplication());
        return new OpusEncoder(pointer);
    }

    private static native long createNative(int var0, boolean var1, int var2, int var3);

    private OpusEncoder(long pointer) {
        this.pointer = pointer;
    }

    public byte[] encode(short[] samples) throws OpusException {
        if (!this.isOpen()) {
            throw new OpusException("Encoder is closed");
        }
        return this.encodeNative(samples);
    }

    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        this.resetNative();
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.closeNative();
    }

    public void setBitrate(int bitrate) {
        if (!this.isOpen()) {
            return;
        }
        this.setBitrateNative(bitrate);
    }

    public int getBitrate() throws OpusException {
        if (!this.isOpen()) {
            throw new OpusException("Encoder is closed");
        }
        return this.getBitrateNative();
    }

    public boolean isOpen() {
        return this.pointer > 0L;
    }

    private native byte[] encodeNative(short[] var1);

    private native void resetNative();

    private native void closeNative();

    private native void setBitrateNative(int var1);

    private native int getBitrateNative();
}

