/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text.minimessage.internal.parser.node;

import org.jetbrains.annotations.NotNull;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.parser.Token;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.parser.TokenParser;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.Tag;

public final class TagPart
implements Tag.Argument {
    private final String value;
    private final Token token;

    public TagPart(@NotNull String sourceMessage, @NotNull Token token2, @NotNull TokenParser.TagProvider tagResolver) {
        String v = TagPart.unquoteAndEscape(sourceMessage, token2.startIndex(), token2.endIndex());
        this.value = v = TokenParser.resolvePreProcessTags(v, tagResolver);
        this.token = token2;
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @NotNull
    public Token token() {
        return this.token;
    }

    @NotNull
    public static String unquoteAndEscape(@NotNull String text, int start2, int end) {
        if (start2 == end) {
            return "";
        }
        int startIndex = start2;
        int endIndex = end;
        char firstChar = text.charAt(startIndex);
        char lastChar = text.charAt(endIndex - 1);
        if (firstChar == '\'' || firstChar == '\"') {
            ++startIndex;
        } else {
            return text.substring(startIndex, endIndex);
        }
        if (lastChar == '\'' || lastChar == '\"') {
            --endIndex;
        }
        if (startIndex > endIndex) {
            return text.substring(start2, end);
        }
        return TokenParser.unescape(text, startIndex, endIndex, i -> i == firstChar || i == 92);
    }

    public String toString() {
        return this.value;
    }
}

