/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.capture;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerPlayerSource;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.jvm.JvmOverloads;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001+B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020%H\u0002J!\u0010&\u001a\u00020\u00152\u0006\u0010 \u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "activation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "sourceLine", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "distanceSupplier", "Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper$DistanceSupplier;", "<init>", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/server/audio/capture/ServerActivation;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper$DistanceSupplier;)V", "getVoiceServer", "()Lsu/plo/voice/api/server/PlasmoVoiceServer;", "getActivation", "()Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "getSourceLine", "()Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "sourceByPlayerId", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "registerListeners", "", "addon", "unregisterListeners", "onClientDisconnected", "event", "Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;", "(Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;)Lkotlin/Unit;", "onActivation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Result;", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "packet", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "onActivationEnd", "Lsu/plo/voice/proto/packets/tcp/serverbound/PlayerAudioEndPacket;", "getPlayerSource", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "isStereo", "", "(Lsu/plo/voice/api/server/player/VoiceServerPlayer;Ljava/lang/Boolean;)Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "DistanceSupplier", "server"})
@SourceDebugExtension(value={"SMAP\nProximityServerActivationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProximityServerActivationHelper.kt\nsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,110:1\n381#2,7:111\n*S KotlinDebug\n*F\n+ 1 ProximityServerActivationHelper.kt\nsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper\n*L\n94#1:111,7\n*E\n"})
public final class ProximityServerActivationHelper {
    @NotNull
    private final PlasmoVoiceServer voiceServer;
    @NotNull
    private final ServerActivation activation;
    @NotNull
    private final ServerSourceLine sourceLine;
    @Nullable
    private final DistanceSupplier distanceSupplier;
    @NotNull
    private final Map<UUID, ServerPlayerSource> sourceByPlayerId;

    @JvmOverloads
    public ProximityServerActivationHelper(@NotNull PlasmoVoiceServer voiceServer, @NotNull ServerActivation activation, @NotNull ServerSourceLine sourceLine, @Nullable DistanceSupplier distanceSupplier) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(activation, "activation");
        Intrinsics.checkNotNullParameter(sourceLine, "sourceLine");
        this.voiceServer = voiceServer;
        this.activation = activation;
        this.sourceLine = sourceLine;
        this.distanceSupplier = distanceSupplier;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.sourceByPlayerId = concurrentMap;
        this.activation.onPlayerActivation(this::onActivation);
        this.activation.onPlayerActivationEnd(this::onActivationEnd);
    }

    public /* synthetic */ ProximityServerActivationHelper(PlasmoVoiceServer plasmoVoiceServer, ServerActivation serverActivation, ServerSourceLine serverSourceLine, DistanceSupplier distanceSupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            distanceSupplier = null;
        }
        this(plasmoVoiceServer, serverActivation, serverSourceLine, distanceSupplier);
    }

    @NotNull
    public final PlasmoVoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    @NotNull
    public final ServerActivation getActivation() {
        return this.activation;
    }

    @NotNull
    public final ServerSourceLine getSourceLine() {
        return this.sourceLine;
    }

    public final void registerListeners(@NotNull Object addon) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        this.voiceServer.getEventBus().register(addon, this);
    }

    public final void unregisterListeners(@NotNull Object addon) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        this.voiceServer.getEventBus().unregister(addon, this);
    }

    @EventSubscribe
    @Nullable
    public final Unit onClientDisconnected(@NotNull UdpClientDisconnectedEvent event) {
        Unit unit;
        Intrinsics.checkNotNullParameter(event, "event");
        ServerPlayerSource serverPlayerSource = this.sourceByPlayerId.remove(event.getConnection().getPlayer().getInstance().getUuid());
        if (serverPlayerSource != null) {
            serverPlayerSource.remove();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final ServerActivation.Result onActivation(VoicePlayer player, PlayerAudioPacket packet) {
        ServerPlayerSource serverPlayerSource;
        Intrinsics.checkNotNull(player, "null cannot be cast to non-null type su.plo.voice.api.server.player.VoiceServerPlayer");
        ServerPlayerSource source2 = serverPlayerSource = this.getPlayerSource((VoiceServerPlayer)player, packet.isStereo());
        boolean bl = false;
        DistanceSupplier distanceSupplier = this.distanceSupplier;
        short distance = distanceSupplier != null ? distanceSupplier.getDistance((VoiceServerPlayer)player, packet) : packet.getDistance();
        SourceAudioPacket sourcePacket = new SourceAudioPacket(packet.getSequenceNumber(), (byte)source2.getState(), packet.getData(), source2.getId(), distance);
        PlayerActivationInfo activationInfo = new PlayerActivationInfo(player, packet);
        if (source2.sendAudioPacket(sourcePacket, distance, activationInfo)) {
            return ServerActivation.Result.HANDLED;
        }
        return ServerActivation.Result.IGNORED;
    }

    private final ServerActivation.Result onActivationEnd(VoicePlayer player, PlayerAudioEndPacket packet) {
        ServerPlayerSource serverPlayerSource;
        Intrinsics.checkNotNull(player, "null cannot be cast to non-null type su.plo.voice.api.server.player.VoiceServerPlayer");
        ServerPlayerSource source2 = serverPlayerSource = ProximityServerActivationHelper.getPlayerSource$default(this, (VoiceServerPlayer)player, null, 2, null);
        boolean bl = false;
        DistanceSupplier distanceSupplier = this.distanceSupplier;
        short distance = distanceSupplier != null ? distanceSupplier.getDistance((VoiceServerPlayer)player, packet) : packet.getDistance();
        SourceAudioEndPacket sourceEndPacket = new SourceAudioEndPacket(source2.getId(), packet.getSequenceNumber());
        if (source2.sendPacket(sourceEndPacket, distance)) {
            return ServerActivation.Result.HANDLED;
        }
        return ServerActivation.Result.IGNORED;
    }

    /*
     * WARNING - void declaration
     */
    private final ServerPlayerSource getPlayerSource(VoiceServerPlayer player, Boolean isStereo) {
        Map<UUID, ServerPlayerSource> map2;
        block2: {
            Object object;
            void $this$getOrPut$iv;
            map2 = this.sourceByPlayerId;
            UUID key$iv = player.getInstance().getUuid();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ServerPlayerSource answer$iv = ServerSourceLine.createPlayerSource$default(this.sourceLine, player, false, 2, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            ServerPlayerSource $this$getPlayerSource_u24lambda_u244 = (ServerPlayerSource)((Object)map2);
            boolean bl = false;
            Boolean bl2 = isStereo;
            if (bl2 == null) break block2;
            boolean isStereo2 = bl2;
            boolean bl3 = false;
            $this$getPlayerSource_u24lambda_u244.setStereo(isStereo2 && this.activation.isStereoSupported());
        }
        return (ServerPlayerSource)((Object)map2);
    }

    static /* synthetic */ ServerPlayerSource getPlayerSource$default(ProximityServerActivationHelper proximityServerActivationHelper, VoiceServerPlayer voiceServerPlayer, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return proximityServerActivationHelper.getPlayerSource(voiceServerPlayer, bl);
    }

    @JvmOverloads
    public ProximityServerActivationHelper(@NotNull PlasmoVoiceServer voiceServer, @NotNull ServerActivation activation, @NotNull ServerSourceLine sourceLine) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(activation, "activation");
        Intrinsics.checkNotNullParameter(sourceLine, "sourceLine");
        this(voiceServer, activation, sourceLine, null, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper$DistanceSupplier;", "", "getDistance", "", "player", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "packet", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "Lsu/plo/voice/proto/packets/tcp/serverbound/PlayerAudioEndPacket;", "server"})
    public static interface DistanceSupplier {
        public short getDistance(@NotNull VoiceServerPlayer var1, @NotNull PlayerAudioPacket var2);

        public short getDistance(@NotNull VoiceServerPlayer var1, @NotNull PlayerAudioEndPacket var2);
    }
}

