/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.source;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.audio.source.AudioSource;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.data.audio.source.SourceInfo;

public interface ServerAudioSource<S extends SourceInfo>
extends AudioSource<S> {
    @NotNull
    public AddonContainer getAddon();

    @NotNull
    public UUID getId();

    @NotNull
    public BaseServerSourceLine getLine();

    public int getState();

    public void setIconVisible(boolean var1);

    public void setStereo(boolean var1);

    public void setName(@Nullable String var1);

    public void setDirty();

    public boolean isIconVisible();

    @NotNull
    public CompletableFuture<S> resolveSourceInfo();

    public <P extends VoicePlayer> void addFilter(@NotNull Predicate<? super P> var1);

    public <P extends VoicePlayer> void removeFilter(@NotNull Predicate<? super P> var1);

    @NotNull
    public Collection<Predicate<? super VoicePlayer>> getFilters();

    public void clearFilters();

    default public void remove() {
        this.getLine().removeSource(this);
    }

    public <P extends VoicePlayer> boolean matchFilters(@NotNull P var1);

    default public <P extends VoicePlayer> boolean notMatchFilters(@NotNull P player) {
        return !this.matchFilters(player);
    }
}

