/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.plo.config.provider.ConfigurationProvider;
import su.plo.config.provider.toml.TomlConfiguration;
import su.plo.lib.mod.client.MinecraftUtil;
import su.plo.lib.mod.client.chat.ClientChatUtil;
import su.plo.lib.mod.client.chat.ClientLanguageSupplier;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.style.McTextClickEvent;
import su.plo.slib.api.chat.style.McTextHoverEvent;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.addon.ClientAddonsLoader;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.AudioCapture;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.audio.line.ClientSourceLineManager;
import su.plo.voice.api.client.audio.source.ClientSourceManager;
import su.plo.voice.api.client.config.addon.AddonConfig;
import su.plo.voice.api.client.config.hotkey.Hotkeys;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.connection.UdpClientManager;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientConnectedEvent;
import su.plo.voice.api.client.render.DistanceVisualizer;
import su.plo.voice.api.client.time.SystemTimeSupplier;
import su.plo.voice.api.client.time.TimeSupplier;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.audio.capture.VoiceAudioCapture;
import su.plo.voice.client.audio.capture.VoiceClientActivationManager;
import su.plo.voice.client.audio.device.VoiceDeviceFactoryManager;
import su.plo.voice.client.audio.device.VoiceDeviceManager;
import su.plo.voice.client.audio.line.VoiceClientSourceLineManager;
import su.plo.voice.client.audio.source.VoiceClientSourceManager;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.addon.VoiceAddonConfig;
import su.plo.voice.client.config.hotkey.HotkeyActions;
import su.plo.voice.client.connection.VoiceUdpClientManager;
import su.plo.voice.client.crowdin.PlasmoCrowdinMod;
import su.plo.voice.client.event.HudRenderEvent;
import su.plo.voice.client.gui.PlayerVolumeAction;
import su.plo.voice.client.render.cape.DeveloperCapeManager;
import su.plo.voice.client.render.voice.HudIconRenderer;
import su.plo.voice.client.render.voice.OverlayRenderer;
import su.plo.voice.client.render.voice.SourceIconRenderer;
import su.plo.voice.client.render.voice.VoiceDistanceVisualizer;
import su.plo.voice.util.version.ModrinthLoader;
import su.plo.voice.util.version.ModrinthVersion;
import su.plo.voice.util.version.SemanticVersion;

public abstract class BaseVoiceClient
extends BaseVoice
implements PlasmoVoiceClient {
    protected static final ConfigurationProvider toml = (ConfigurationProvider)ConfigurationProvider.getProvider(TomlConfiguration.class);
    private final DeviceFactoryManager deviceFactoryManager = new VoiceDeviceFactoryManager();
    private final UdpClientManager udpClientManager = new VoiceUdpClientManager();
    private ServerInfo serverInfo;
    private VoiceDeviceManager deviceManager;
    private AudioCapture audioCapture;
    private ClientActivationManager activationManager;
    private ClientSourceLineManager sourceLineManager;
    private ClientSourceManager sourceManager;
    private DistanceVisualizer distanceVisualizer;
    private TimeSupplier timeSupplier = new SystemTimeSupplier();
    protected VoiceClientConfig config;
    protected final Map<String, AddonConfig> addonConfigs = Maps.newHashMap();
    private boolean updatesChecked;

    protected BaseVoiceClient(@NotNull ModrinthLoader loader) {
        super(loader);
        ClientAddonsLoader.INSTANCE.setAddonManager(this.getAddonManager());
    }

    @EventSubscribe
    public void onUdpConnected(@NotNull UdpClientConnectedEvent event) {
        if (this.updatesChecked) {
            return;
        }
        this.updatesChecked = true;
        this.backgroundExecutor.execute(() -> {
            try {
                if (!SemanticVersion.parse(this.getVersion()).isRelease() || !((Boolean)this.config.getCheckForUpdates().value()).booleanValue()) {
                    return;
                }
                ModrinthVersion.checkForUpdates(this.getVersion(), MinecraftUtil.getVersion(), this.loader).ifPresent(version -> ClientChatUtil.sendChatMessage(RenderUtil.getTextConverter().convert(McTextComponent.translatable("message.plasmovoice.update_available", version.version(), McTextComponent.translatable("message.plasmovoice.update_available.click", new Object[0]).withStyle(McTextStyle.YELLOW).clickEvent(McTextClickEvent.openUrl(version.downloadLink())).hoverEvent(McTextHoverEvent.showText(McTextComponent.translatable("message.plasmovoice.update_available.hover", version.downloadLink())))))));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to check for updates", e);
            }
        });
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.loadConfig();
        if (!((Boolean)this.config.getDisableCrowdin().value()).booleanValue()) {
            PlasmoCrowdinMod.INSTANCE.downloadTranslations(new File(this.getConfigFolder(), PlasmoCrowdinMod.INSTANCE.getFolderName()));
        }
        this.distanceVisualizer = new VoiceDistanceVisualizer(this, this.config);
        this.deviceManager = new VoiceDeviceManager(this, this.config);
        this.sourceLineManager = new VoiceClientSourceLineManager(this.config);
        this.activationManager = new VoiceClientActivationManager(this, this.config);
        this.sourceManager = new VoiceClientSourceManager(this, this.config);
        this.audioCapture = new VoiceAudioCapture(this, this.config);
        this.eventBus.register(this, this.sourceManager);
        new HotkeyActions(this, this.getHotkeys(), this.config).register();
        PlayerVolumeAction volumeAction = new PlayerVolumeAction(this, this.config);
        this.eventBus.register(this, volumeAction);
        this.eventBus.register(this, this.distanceVisualizer);
        HudRenderEvent.INSTANCE.registerListener(new HudIconRenderer(this, this.config));
        this.eventBus.register(this, new SourceIconRenderer(this, this.config, volumeAction));
        HudRenderEvent.INSTANCE.registerListener(new OverlayRenderer(this, this.config));
        this.addons.initializeLoadedAddons();
    }

    @Override
    protected void onShutdown() {
        LOGGER.info("Shutting down", new Object[0]);
        this.eventBus.unregister(this);
        super.onShutdown();
    }

    protected void onServerDisconnect() {
        this.config.save(true);
        this.udpClientManager.removeClient(UdpClientClosedEvent.Reason.DISCONNECT);
        this.getServerConnection().ifPresent(ServerConnection::close);
        DeveloperCapeManager.INSTANCE.clearLoadedCapes();
        this.updatesChecked = false;
    }

    @Override
    public Optional<ServerInfo> getServerInfo() {
        return Optional.ofNullable(this.serverInfo);
    }

    @Override
    @NotNull
    public Hotkeys getHotkeys() {
        return this.config.getKeyBindings();
    }

    @Override
    @NotNull
    public synchronized AddonConfig getAddonConfig(@NotNull Object addonInstance) {
        AddonContainer addon = this.addons.getAddon(addonInstance).orElseThrow(() -> new IllegalArgumentException("Addon not found"));
        return this.addonConfigs.computeIfAbsent(addon.getId(), addonId -> new VoiceAddonConfig(addon, this.config.getAddons().getAddon(addon.getId())));
    }

    protected ClientLanguageSupplier createLanguageSupplier() {
        return () -> this.getServerConnection().map(ServerConnection::getLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        File configFile = new File(this.getConfigFolder(), "client.toml");
        try {
            this.config = (VoiceClientConfig)toml.load(VoiceClientConfig.class, configFile, false);
            toml.save(VoiceClientConfig.class, this.config, configFile);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load the config", e);
            try {
                this.config = new VoiceClientConfig();
                toml.save(VoiceClientConfig.class, this.config, configFile);
            }
            catch (Exception e1) {
                throw new RuntimeException("Failed to save default config", e1);
            }
        }
        finally {
            this.config.setConfigFile(configFile);
            this.config.setAsyncExecutor(this.backgroundExecutor);
            this.eventBus.register(this, this.config.getKeyBindings());
        }
        BaseVoice.DEBUG_LOGGER.enabled((Boolean)this.config.getDebug().value() != false || System.getProperty("plasmovoice.debug") != null);
    }

    @Override
    public DeviceFactoryManager getDeviceFactoryManager() {
        return this.deviceFactoryManager;
    }

    @Override
    public UdpClientManager getUdpClientManager() {
        return this.udpClientManager;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public VoiceDeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    @Override
    public AudioCapture getAudioCapture() {
        return this.audioCapture;
    }

    @Override
    public ClientActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    public ClientSourceLineManager getSourceLineManager() {
        return this.sourceLineManager;
    }

    @Override
    public ClientSourceManager getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public DistanceVisualizer getDistanceVisualizer() {
        return this.distanceVisualizer;
    }

    @Override
    public TimeSupplier getTimeSupplier() {
        return this.timeSupplier;
    }

    @Override
    public void setTimeSupplier(TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    @Override
    public VoiceClientConfig getConfig() {
        return this.config;
    }

    public Map<String, AddonConfig> getAddonConfigs() {
        return this.addonConfigs;
    }
}

