/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.encryption;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Arrays;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.PacketUtil;

public final class EncryptionInfo
implements PacketSerializable {
    private String algorithm;
    private byte[] data;

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        this.algorithm = in.readUTF();
        int length = PacketUtil.readSafeInt(in, 1, Integer.MAX_VALUE);
        byte[] data = new byte[length];
        in.readFully(data);
        this.data = data;
    }

    @Override
    public void serialize(ByteArrayDataOutput out) {
        Preconditions.checkNotNull((Object)this.algorithm, (Object)"algorithm cannot be null");
        Preconditions.checkNotNull((Object)this.data, (Object)"data cannot be null");
        out.writeUTF(this.algorithm);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public EncryptionInfo(String algorithm, byte[] data) {
        this.algorithm = algorithm;
        this.data = data;
    }

    public EncryptionInfo() {
    }

    public String toString() {
        return "EncryptionInfo(algorithm=" + this.getAlgorithm() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getData() {
        return this.data;
    }
}

