/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public class ConfigPlayerInfoPacket
implements Packet<ClientPacketTcpHandler> {
    private Map<String, Boolean> permissions = new HashMap<String, Boolean>();

    public ConfigPlayerInfoPacket(@NotNull Map<String, Boolean> permissions) {
        this.permissions = (Map)Preconditions.checkNotNull(permissions, (Object)"playerPermissions cannot be null");
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            boolean value = in.readBoolean();
            this.permissions.put(key, value);
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeInt(this.permissions.size());
        this.permissions.forEach((permission, value) -> {
            out.writeUTF(permission);
            out.writeBoolean(value.booleanValue());
        });
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public ConfigPlayerInfoPacket() {
    }

    public String toString() {
        return "ConfigPlayerInfoPacket(permissions=" + this.getPermissions() + ")";
    }

    public Map<String, Boolean> getPermissions() {
        return this.permissions;
    }
}

