/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class PlayerDisconnectPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID playerId;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.playerId = PacketUtil.readUUID(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.playerId));
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public PlayerDisconnectPacket(UUID playerId) {
        this.playerId = playerId;
    }

    public PlayerDisconnectPacket() {
    }

    public String toString() {
        return "PlayerDisconnectPacket(playerId=" + this.getPlayerId() + ")";
    }

    public UUID getPlayerId() {
        return this.playerId;
    }
}

