/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerDirectSource;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpConnection;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.server.audio.source.VoiceBaseServerDirectSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016R\u0014\u0010\u0011\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerDirectSource;", "Lsu/plo/voice/server/audio/source/VoiceBaseServerDirectSource;", "Lsu/plo/voice/api/server/audio/source/ServerDirectSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "udpConnections", "Lsu/plo/voice/api/server/connection/UdpConnectionManager;", "Lsu/plo/voice/api/server/player/VoicePlayer;", "Lsu/plo/voice/api/server/socket/UdpConnection;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "player", "<init>", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/server/connection/UdpConnectionManager;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/voice/api/server/player/VoicePlayer;)V", "getPlayer", "()Lsu/plo/voice/api/server/player/VoicePlayer;", "sendAudioPacket", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "activationInfo", "Lsu/plo/voice/api/server/audio/capture/PlayerActivationInfo;", "sendPacket", "Lsu/plo/voice/proto/packets/Packet;", "server-proxy-common"})
public final class VoiceServerDirectSource
extends VoiceBaseServerDirectSource
implements ServerDirectSource {
    @NotNull
    private final VoicePlayer player;

    public VoiceServerDirectSource(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections, @NotNull AddonContainer addon, @NotNull BaseServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(udpConnections, "udpConnections");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(player, "player");
        super(voiceServer, udpConnections, addon, line, decoderInfo, stereo);
        this.player = player;
    }

    @Override
    @NotNull
    public VoicePlayer getPlayer() {
        return this.player;
    }

    @Override
    public boolean sendAudioPacket(@NotNull SourceAudioPacket packet, @Nullable PlayerActivationInfo activationInfo) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        ServerSourceAudioPacketEvent event = new ServerSourceAudioPacketEvent(this, packet, activationInfo);
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        if (event.getResult() == ServerSourceAudioPacketEvent.Result.HANDLED) {
            return true;
        }
        packet.setSourceState((byte)this.state.get());
        if (this.dirty.compareAndSet(true, false)) {
            this.updateSourceInfo();
        }
        if (this.matchFilters(this.getPlayer())) {
            Optional optional = this.udpConnections.getConnectionByPlayerId(this.getPlayer().getInstance().getUuid());
            Intrinsics.checkNotNullExpressionValue(optional, "getConnectionByPlayerId(...)");
            UdpConnection udpConnection = (UdpConnection)OptionalsKt.getOrNull(optional);
            if (udpConnection != null) {
                udpConnection.sendPacket(packet);
            }
        }
        return true;
    }

    @Override
    public boolean sendPacket(@NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        ServerSourcePacketEvent event = new ServerSourcePacketEvent(this, packet);
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        if (event.getResult() == ServerSourcePacketEvent.Result.HANDLED) {
            return true;
        }
        if (this.matchFilters(this.getPlayer())) {
            this.getPlayer().sendPacket(packet);
        }
        return true;
    }
}

