/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.server.channel.McServerChannelHandler;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.voice.BaseVoice;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.server.BaseVoiceServer;

public final class ServerServiceChannelHandler
implements McServerChannelHandler {
    private final BaseVoiceServer voiceServer;

    @Override
    public void receive(@NotNull McServerPlayer serverPlayer, @NotNull byte[] bytes) {
        if (this.voiceServer.getConfig().host().forwardingSecret() == null) {
            return;
        }
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])bytes);
        try {
            byte[] signature = PacketUtil.readBytes(input, 32);
            byte[] aesEncryptionKey = PacketUtil.readBytes(input, 64);
            SecretKeySpec key = new SecretKeySpec(PacketUtil.getUUIDBytes(this.voiceServer.getConfig().host().forwardingSecret()), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(key);
            mac.update(aesEncryptionKey, 0, aesEncryptionKey.length);
            if (!MessageDigest.isEqual(signature, mac.doFinal())) {
                BaseVoice.LOGGER.warn("Received invalid AES key signature from player {}", serverPlayer.getUuid());
                return;
            }
            this.voiceServer.updateAesEncryptionKey(aesEncryptionKey);
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            PacketUtil.writeBytes(output, signature);
            serverPlayer.sendPacket("plasmo:voice/v2/service", output.toByteArray());
            BaseVoice.DEBUG_LOGGER.log("Received AES key from proxy server", new Object[0]);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }

    public ServerServiceChannelHandler(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

